"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navigateToLegacyKibanaUrl = void 0;
var _normalize_path = require("./normalize_path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const navigateToLegacyKibanaUrl = (path, forwards, basePath, application) => {
  const normalizedPath = (0, _normalize_path.normalizePath)(path);

  // try to find an existing redirect for the target path if possible
  // this avoids having to load the legacy app just to get redirected to a core application again afterwards
  const relevantForward = forwards.find(forward => normalizedPath.startsWith(`/${forward.legacyAppId}`));
  if (!relevantForward) {
    return {
      navigated: false
    };
  }
  const targetAppPath = relevantForward.rewritePath(normalizedPath);
  const targetAppId = relevantForward.newAppId;
  application.navigateToApp(targetAppId, {
    path: targetAppPath,
    replace: true
  });
  return {
    navigated: true
  };
};
exports.navigateToLegacyKibanaUrl = navigateToLegacyKibanaUrl;