"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/observability-plugin/public");
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _plugin = require("../common/constants/plugin");
var _fleet_package = require("./legacy_uptime/components/fleet_package");
var _lazy_synthetics_custom_assets_extension = require("./legacy_uptime/components/fleet_package/lazy_synthetics_custom_assets_extension");
var _alert_types = require("./legacy_uptime/lib/alert_types");
var _kibana_services = require("./kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class UptimePlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "uptimeAppUpdater", new _rxjs.BehaviorSubject(() => ({})));
    this.initContext = initContext;
  }
  setup(core, plugins) {
    if (plugins.home) {
      plugins.home.featureCatalogue.register({
        id: _plugin.PLUGIN.ID,
        title: _plugin.PLUGIN.TITLE,
        description: _plugin.PLUGIN.DESCRIPTION,
        icon: 'uptimeApp',
        path: '/app/uptime',
        showOnHomePage: false,
        category: 'data'
      });
    }
    const getUptimeDataHelper = async () => {
      const [coreStart] = await core.getStartServices();
      const {
        UptimeDataHelper
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./legacy_uptime/app/uptime_overview_fetcher')));
      return UptimeDataHelper(coreStart);
    };
    plugins.observability.dashboard.register({
      appName: 'uptime',
      hasData: async () => {
        const dataHelper = await getUptimeDataHelper();
        const status = await dataHelper.indexStatus();
        return {
          hasData: status.indexExists,
          indices: status.indices
        };
      },
      fetchData: async params => {
        const dataHelper = await getUptimeDataHelper();
        return await dataHelper.overviewData(params);
      }
    });
    plugins.exploratoryView.register({
      appName: 'uptime',
      hasData: async () => {
        const dataHelper = await getUptimeDataHelper();
        const status = await dataHelper.indexStatus();
        return {
          hasData: status.indexExists,
          indices: status.indices
        };
      },
      fetchData: async params => {
        const dataHelper = await getUptimeDataHelper();
        return await dataHelper.overviewData(params);
      }
    });
    const appKeywords = ['Synthetics', 'availability', 'browser', 'checks', 'digital', 'reachability', 'reachable', 'response duration', 'response time', 'monitors', 'outside in', 'performance', 'pings', 'web performance', 'web perf'];
    core.application.register({
      id: _plugin.PLUGIN.ID,
      euiIconType: 'logoObservability',
      order: 8400,
      title: _plugin.PLUGIN.TITLE,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      keywords: appKeywords,
      deepLinks: [{
        id: 'Down monitors',
        title: 'Down monitors',
        path: '/?statusFilter=down'
      }, {
        id: 'Certificates',
        title: 'TLS Certificates',
        path: '/certificates'
      }, {
        id: 'Settings',
        title: 'Settings',
        path: '/settings'
      }],
      mount: async params => {
        const [coreStart, corePlugins] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./legacy_uptime/app/render_app')));
        return renderApp(coreStart, plugins, corePlugins, params, this.initContext.env.mode.dev);
      },
      updater$: this.uptimeAppUpdater
    });
  }
  start(coreStart, pluginsStart) {
    const {
      registerExtension
    } = pluginsStart.fleet;
    (0, _kibana_services.setStartServices)(coreStart);
    registerUptimeFleetExtensions(registerExtension);
    setUptimeAppStatus(this.initContext.env.packageInfo.version, coreStart, pluginsStart, this.uptimeAppUpdater);
  }
  stop() {}
}
exports.UptimePlugin = UptimePlugin;
function registerUptimeRoutesWithNavigation(coreStart, plugins) {
  async function getUptimeSections() {
    var _coreStart$applicatio;
    if ((_coreStart$applicatio = coreStart.application.capabilities.uptime) !== null && _coreStart$applicatio !== void 0 && _coreStart$applicatio.show) {
      return [{
        label: 'Uptime',
        sortKey: 500,
        entries: [{
          label: _i18n.i18n.translate('xpack.uptime.overview.uptimeHeading', {
            defaultMessage: 'Uptime Monitors'
          }),
          app: 'uptime',
          path: '/',
          matchFullPath: true,
          ignoreTrailingSlash: true
        }, {
          label: _i18n.i18n.translate('xpack.uptime.certificatesPage.heading', {
            defaultMessage: 'TLS Certificates'
          }),
          app: 'uptime',
          path: '/certificates',
          matchFullPath: true
        }]
      }];
    }
    return [];
  }
  plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(getUptimeSections()));
}
function registerUptimeFleetExtensions(registerExtension) {
  registerExtension({
    package: 'synthetics',
    view: 'package-policy-create',
    Component: _fleet_package.LazySyntheticsPolicyCreateExtension
  });
  registerExtension({
    package: 'synthetics',
    view: 'package-policy-edit',
    useLatestPackageVersion: true,
    Component: _fleet_package.LazySyntheticsPolicyEditExtension
  });
  registerExtension({
    package: 'synthetics',
    view: 'package-detail-assets',
    Component: _lazy_synthetics_custom_assets_extension.LazySyntheticsCustomAssetsExtension
  });
}
function setUptimeAppStatus(stackVersion, coreStart, pluginsStart, updater) {
  Promise.resolve().then(() => _interopRequireWildcard(require('./legacy_uptime/app/uptime_overview_fetcher'))).then(({
    UptimeDataHelper
  }) => {
    const isEnabled = coreStart.uiSettings.get(_public2.enableLegacyUptimeApp);
    if (isEnabled) {
      registerUptimeRoutesWithNavigation(coreStart, pluginsStart);
      registerAlertRules(coreStart, pluginsStart, stackVersion, false);
      updater.next(() => ({
        status: _coreApplicationBrowser.AppStatus.accessible
      }));
    } else {
      const indexStatusPromise = UptimeDataHelper(coreStart).indexStatus('now-7d', 'now');
      indexStatusPromise.then(indexStatus => {
        if (indexStatus.indexExists) {
          registerUptimeRoutesWithNavigation(coreStart, pluginsStart);
          updater.next(() => ({
            status: _coreApplicationBrowser.AppStatus.accessible
          }));
          registerAlertRules(coreStart, pluginsStart, stackVersion, false);
        } else {
          updater.next(() => ({
            status: _coreApplicationBrowser.AppStatus.inaccessible
          }));
          registerAlertRules(coreStart, pluginsStart, stackVersion, true);
        }
      });
    }
  });
}
function registerAlertRules(coreStart, pluginsStart, stackVersion, isHidden = false) {
  _alert_types.uptimeAlertTypeInitializers.forEach(init => {
    const {
      observabilityRuleTypeRegistry
    } = pluginsStart.observability;
    const alertInitializer = init({
      isHidden,
      stackVersion,
      core: coreStart,
      plugins: pluginsStart
    });
    if (!pluginsStart.triggersActionsUi.ruleTypeRegistry.has(alertInitializer.id)) {
      observabilityRuleTypeRegistry.register(alertInitializer);
    }
  });
  _alert_types.legacyAlertTypeInitializers.forEach(init => {
    const alertInitializer = init({
      isHidden,
      stackVersion,
      core: coreStart,
      plugins: pluginsStart
    });
    if (!pluginsStart.triggersActionsUi.ruleTypeRegistry.has(alertInitializer.id)) {
      pluginsStart.triggersActionsUi.ruleTypeRegistry.register(alertInitializer);
    }
  });
}