"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepDetailPage = exports.StepDetailPageRightSideItem = exports.StepDetailPageHeader = exports.StepDetailPageChildren = exports.StepDetailPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _use_init_app = require("../../hooks/use_init_app");
var _step_detail_container = require("../../components/monitor/synthetics/step_detail/step_detail_container");
var _selectors = require("../../state/selectors");
var _step_page_nav = require("../../components/monitor/synthetics/step_detail/step_page_nav");
var _step_page_title = require("../../components/monitor/synthetics/step_detail/step_page_title");
var _journey = require("../../state/actions/journey");
var _dynamic_settings = require("../../state/actions/dynamic_settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStepDetailPage = () => {
  var _journeys$checkGroup, _journey$details2, _journey$details2$nex, _journey$details4, _journey$details4$pre;
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    checkGroupId: checkGroup,
    stepIndex: stepIndexString
  } = (0, _reactRouterDom.useParams)();
  (0, _react.useEffect)(() => {
    if (checkGroup) {
      dispatch((0, _journey.getJourneySteps)({
        checkGroup,
        syntheticEventTypes: ['step/end']
      }));
    }
  }, [dispatch, checkGroup]);
  const stepIndex = Number(stepIndexString);
  const journeys = (0, _reactRedux.useSelector)(_selectors.journeySelector);
  const journey = (_journeys$checkGroup = journeys[checkGroup]) !== null && _journeys$checkGroup !== void 0 ? _journeys$checkGroup : null;
  const memoized = (0, _react.useMemo)(() => {
    var _journey$steps;
    return {
      hasPreviousStep: stepIndex > 1 ? true : false,
      activeStep: journey === null || journey === void 0 ? void 0 : (_journey$steps = journey.steps) === null || _journey$steps === void 0 ? void 0 : _journey$steps.find(step => {
        var _step$synthetics, _step$synthetics$step;
        return ((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$step = _step$synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.index) === stepIndex;
      }),
      hasNextStep: journey && journey.steps && stepIndex < journey.steps.length ? true : false
    };
  }, [journey, stepIndex]);
  const handleNextStep = (0, _react.useCallback)(() => {
    history.push(`/journey/${checkGroup}/step/${stepIndex + 1}`);
  }, [history, checkGroup, stepIndex]);
  const handlePreviousStep = (0, _react.useCallback)(() => {
    history.push(`/journey/${checkGroup}/step/${stepIndex - 1}`);
  }, [history, checkGroup, stepIndex]);
  const handleNextRun = (0, _react.useCallback)(() => {
    var _journey$details, _journey$details$next;
    history.push(`/journey/${journey === null || journey === void 0 ? void 0 : (_journey$details = journey.details) === null || _journey$details === void 0 ? void 0 : (_journey$details$next = _journey$details.next) === null || _journey$details$next === void 0 ? void 0 : _journey$details$next.checkGroup}/step/1`);
  }, [history, journey === null || journey === void 0 ? void 0 : (_journey$details2 = journey.details) === null || _journey$details2 === void 0 ? void 0 : (_journey$details2$nex = _journey$details2.next) === null || _journey$details2$nex === void 0 ? void 0 : _journey$details2$nex.checkGroup]);
  const handlePreviousRun = (0, _react.useCallback)(() => {
    var _journey$details3, _journey$details3$pre;
    history.push(`/journey/${journey === null || journey === void 0 ? void 0 : (_journey$details3 = journey.details) === null || _journey$details3 === void 0 ? void 0 : (_journey$details3$pre = _journey$details3.previous) === null || _journey$details3$pre === void 0 ? void 0 : _journey$details3$pre.checkGroup}/step/1`);
  }, [history, journey === null || journey === void 0 ? void 0 : (_journey$details4 = journey.details) === null || _journey$details4 === void 0 ? void 0 : (_journey$details4$pre = _journey$details4.previous) === null || _journey$details4$pre === void 0 ? void 0 : _journey$details4$pre.checkGroup]);
  return {
    checkGroup,
    journey,
    stepIndex,
    ...memoized,
    handleNextStep,
    handlePreviousStep,
    handleNextRun,
    handlePreviousRun
  };
};
exports.useStepDetailPage = useStepDetailPage;
const StepDetailPageHeader = () => {
  var _activeStep$synthetic, _activeStep$synthetic2;
  const {
    activeStep,
    journey
  } = useStepDetailPage();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, journey && activeStep && ((_activeStep$synthetic = activeStep.synthetics) === null || _activeStep$synthetic === void 0 ? void 0 : (_activeStep$synthetic2 = _activeStep$synthetic.step) === null || _activeStep$synthetic2 === void 0 ? void 0 : _activeStep$synthetic2.name));
};
exports.StepDetailPageHeader = StepDetailPageHeader;
const StepDetailPageRightSideItem = () => {
  var _journey$details5, _journey$details5$nex, _journey$details6, _journey$details6$pre, _journey$details7;
  const [dateFormat] = (0, _public2.useUiSetting$)('dateFormat');
  const {
    journey,
    handleNextRun,
    handlePreviousRun
  } = useStepDetailPage();
  if (!journey) return null;
  return /*#__PURE__*/_react.default.createElement(_step_page_nav.StepPageNavigation, {
    dateFormat: dateFormat,
    handleNextRun: handleNextRun,
    handlePreviousRun: handlePreviousRun,
    nextCheckGroup: (_journey$details5 = journey.details) === null || _journey$details5 === void 0 ? void 0 : (_journey$details5$nex = _journey$details5.next) === null || _journey$details5$nex === void 0 ? void 0 : _journey$details5$nex.checkGroup,
    previousCheckGroup: (_journey$details6 = journey.details) === null || _journey$details6 === void 0 ? void 0 : (_journey$details6$pre = _journey$details6.previous) === null || _journey$details6$pre === void 0 ? void 0 : _journey$details6$pre.checkGroup,
    checkTimestamp: (_journey$details7 = journey.details) === null || _journey$details7 === void 0 ? void 0 : _journey$details7.timestamp
  });
};
exports.StepDetailPageRightSideItem = StepDetailPageRightSideItem;
const StepDetailPageChildren = () => {
  var _activeStep$synthetic3, _activeStep$synthetic4, _activeStep$synthetic5;
  const {
    activeStep,
    hasPreviousStep,
    hasNextStep,
    handleNextStep,
    handlePreviousStep,
    journey,
    stepIndex
  } = useStepDetailPage();
  if (!journey || !activeStep) return null;
  return /*#__PURE__*/_react.default.createElement(_step_page_title.StepPageTitleContent, {
    stepName: (_activeStep$synthetic3 = (_activeStep$synthetic4 = activeStep.synthetics) === null || _activeStep$synthetic4 === void 0 ? void 0 : (_activeStep$synthetic5 = _activeStep$synthetic4.step) === null || _activeStep$synthetic5 === void 0 ? void 0 : _activeStep$synthetic5.name) !== null && _activeStep$synthetic3 !== void 0 ? _activeStep$synthetic3 : '',
    stepIndex: stepIndex,
    totalSteps: journey.steps.length,
    hasPreviousStep: hasPreviousStep,
    hasNextStep: hasNextStep,
    handlePreviousStep: handlePreviousStep,
    handleNextStep: handleNextStep
  });
};
exports.StepDetailPageChildren = StepDetailPageChildren;
const StepDetailPage = () => {
  (0, _use_init_app.useInitApp)();
  const {
    checkGroupId,
    stepIndex
  } = (0, _reactRouterDom.useParams)();
  (0, _public.useTrackPageview)({
    app: 'uptime',
    path: 'stepDetail'
  });
  (0, _public.useTrackPageview)({
    app: 'uptime',
    path: 'stepDetail',
    delay: 15000
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch((0, _dynamic_settings.getDynamicSettings)());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_step_detail_container.StepDetailContainer, {
    checkGroup: checkGroupId,
    stepIndex: Number(stepIndex)
  });
};
exports.StepDetailPage = StepDetailPage;