"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusExpressionSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _down_number_select = require("./down_number_select");
var _time_expression_select = require("./time_expression_select");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusExpressionSelect = ({
  ruleParams,
  hasFilters,
  setRuleParams
}) => {
  var _ruleParams$shouldChe;
  const [isEnabled, setIsEnabled] = (0, _react.useState)((_ruleParams$shouldChe = ruleParams.shouldCheckStatus) !== null && _ruleParams$shouldChe !== void 0 ? _ruleParams$shouldChe : true);
  (0, _react.useEffect)(() => {
    setRuleParams('shouldCheckStatus', isEnabled);
  }, [isEnabled, setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "statusEnabled",
    label: _translations.statusExpLabels.ENABLED_CHECKBOX,
    checked: isEnabled,
    onChange: () => setIsEnabled(!isEnabled)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_down_number_select.DownNoExpressionSelect, {
    defaultNumTimes: ruleParams.numTimes,
    hasFilters: hasFilters,
    isEnabled: isEnabled,
    setRuleParams: setRuleParams
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_time_expression_select.TimeExpressionSelect, {
    defaultTimerangeUnit: ruleParams.timerangeUnit,
    defaultTimerangeCount: ruleParams.timerangeCount,
    isEnabled: isEnabled,
    setRuleParams: setRuleParams
  })));
};
exports.StatusExpressionSelect = StatusExpressionSelect;