"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectSeverity = exports.SEVERITY_OPTIONS = exports.DEFAULT_SEVERITY = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _get_severity_color = require("@kbn/ml-anomaly-utils/get_severity_color");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const warningLabel = _i18n.i18n.translate('xpack.uptime.controls.selectSeverity.warningLabel', {
  defaultMessage: 'warning'
});
const minorLabel = _i18n.i18n.translate('xpack.uptime.controls.selectSeverity.minorLabel', {
  defaultMessage: 'minor'
});
const majorLabel = _i18n.i18n.translate('xpack.uptime.controls.selectSeverity.majorLabel', {
  defaultMessage: 'major'
});
const criticalLabel = _i18n.i18n.translate('xpack.uptime.controls.selectSeverity.criticalLabel', {
  defaultMessage: 'critical'
});
const optionsMap = {
  [warningLabel]: 0,
  [minorLabel]: 25,
  [majorLabel]: 50,
  [criticalLabel]: 75
};
const SEVERITY_OPTIONS = [{
  val: 0,
  display: warningLabel,
  color: (0, _get_severity_color.getSeverityColor)(0)
}, {
  val: 25,
  display: minorLabel,
  color: (0, _get_severity_color.getSeverityColor)(25)
}, {
  val: 50,
  display: majorLabel,
  color: (0, _get_severity_color.getSeverityColor)(50)
}, {
  val: 75,
  display: criticalLabel,
  color: (0, _get_severity_color.getSeverityColor)(75)
}];
exports.SEVERITY_OPTIONS = SEVERITY_OPTIONS;
function optionValueToThreshold(value) {
  // Get corresponding threshold object with required display and val properties from the specified value.
  let threshold = SEVERITY_OPTIONS.find(opt => opt.val === value);

  // Default to warning if supplied value doesn't map to one of the options.
  if (threshold === undefined) {
    threshold = SEVERITY_OPTIONS[0];
  }
  return threshold;
}
const DEFAULT_SEVERITY = SEVERITY_OPTIONS[3];
exports.DEFAULT_SEVERITY = DEFAULT_SEVERITY;
const getSeverityOptions = () => SEVERITY_OPTIONS.map(({
  color,
  display,
  val
}) => ({
  'data-test-subj': `alertAnomaly${display}`,
  value: display,
  inputDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    style: {
      lineHeight: 'inherit'
    }
  }, display)),
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    style: {
      lineHeight: 'inherit'
    }
  }, display), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.controls.selectSeverity.scoreDetailsDescription",
    defaultMessage: "score {value} and above",
    values: {
      value: val
    }
  }))))
}));
const SelectSeverity = ({
  onChange,
  value
}) => {
  const [severity, setSeverity] = (0, _react.useState)(DEFAULT_SEVERITY);
  const onSeverityChange = valueDisplay => {
    const option = optionValueToThreshold(optionsMap[valueDisplay]);
    setSeverity(option);
    onChange(option);
  };
  (0, _react.useEffect)(() => {
    setSeverity(value);
  }, [value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    hasDividers: true,
    style: {
      width: 200
    },
    options: getSeverityOptions(),
    valueOfSelected: severity.display,
    onChange: onSeverityChange,
    "data-test-subj": 'anomalySeveritySelect'
  });
};
exports.SelectSeverity = SelectSeverity;