"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prevAriaLabel = exports.nextAriaLabel = exports.imageLoadingSpinnerAriaLabel = exports.fullSizeImageAlt = exports.formatCaptionContent = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const prevAriaLabel = _i18n.i18n.translate('xpack.uptime.synthetics.prevStepButton.airaLabel', {
  defaultMessage: 'Previous step'
});
exports.prevAriaLabel = prevAriaLabel;
const nextAriaLabel = _i18n.i18n.translate('xpack.uptime.synthetics.nextStepButton.ariaLabel', {
  defaultMessage: 'Next step'
});
exports.nextAriaLabel = nextAriaLabel;
const imageLoadingSpinnerAriaLabel = _i18n.i18n.translate('xpack.uptime.synthetics.imageLoadingSpinner.ariaLabel', {
  defaultMessage: 'An animated spinner indicating the image is loading'
});
exports.imageLoadingSpinnerAriaLabel = imageLoadingSpinnerAriaLabel;
const fullSizeImageAlt = _i18n.i18n.translate('xpack.uptime.synthetics.thumbnail.fullSize.alt', {
  defaultMessage: `A larger version of the screenshot for this journey step's thumbnail.`
});
exports.fullSizeImageAlt = fullSizeImageAlt;
const formatCaptionContent = (stepNumber, totalSteps) => _i18n.i18n.translate('xpack.uptime.synthetics.pingTimestamp.captionContent', {
  defaultMessage: 'Step: {stepNumber} of {totalSteps}',
  values: {
    stepNumber,
    totalSteps
  }
});
exports.formatCaptionContent = formatCaptionContent;