"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTickFormat = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTickFormat = value => {
  const parsedNumber = Number(value);
  if (isNaN(parsedNumber) || value === null) {
    return 'N/A';
  }
  return parsedNumber.toFixed();
};
exports.getTickFormat = getTickFormat;