"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DonutChartLegendRow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EuiFlexItemReducedMargin = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  && {
    margin-left: 0px;
    margin-right: 0px;
  }
`;
const EuiFlexItemAlignRight = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  text-align: right;
`;
const DonutChartLegendRow = ({
  color,
  content,
  message,
  'data-test-subj': dts
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "l",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(EuiFlexItemReducedMargin, {
  component: "span",
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
  color: color
})), /*#__PURE__*/_react.default.createElement(EuiFlexItemReducedMargin, {
  component: "span",
  grow: false,
  "data-test-subj": `${dts}.label`
}, message), /*#__PURE__*/_react.default.createElement(EuiFlexItemAlignRight, {
  component: "span",
  "data-test-subj": dts
}, content));
exports.DonutChartLegendRow = DonutChartLegendRow;