"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBackupStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _on_prem_backup = require("./on_prem_backup");
var _cloud_backup = require("./cloud_backup");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const title = _i18n.i18n.translate('xpack.upgradeAssistant.overview.backupStepTitle', {
  defaultMessage: 'Back up your data'
});
const BackupStep = ({
  cloud,
  setIsComplete
}) => {
  const [forceOnPremStep, setForceOnPremStep] = (0, _react.useState)(false);
  if (cloud !== null && cloud !== void 0 && cloud.isCloudEnabled && !forceOnPremStep) {
    return /*#__PURE__*/_react.default.createElement(_cloud_backup.CloudBackup, {
      setIsComplete: setIsComplete,
      cloudSnapshotsUrl: cloud.snapshotsUrl,
      setForceOnPremStep: setForceOnPremStep
    });
  }
  return /*#__PURE__*/_react.default.createElement(_on_prem_backup.OnPremBackup, null);
};
const getBackupStep = ({
  cloud,
  isComplete,
  setIsComplete
}) => {
  const status = cloud !== null && cloud !== void 0 && cloud.isCloudEnabled ? isComplete ? 'complete' : 'incomplete' : 'incomplete';
  return {
    title,
    status,
    'data-test-subj': `backupStep-${status}`,
    children: /*#__PURE__*/_react.default.createElement(BackupStep, {
      cloud: cloud,
      setIsComplete: setIsComplete
    })
  };
};
exports.getBackupStep = getBackupStep;