"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChecklistFlyoutStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../../../common/types");
var _types2 = require("../../../../types");
var _progress = require("./progress");
var _app_context = require("../../../../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buttonLabel = status => {
  switch (status) {
    case _types.ReindexStatus.failed:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexButton.tryAgainLabel",
        defaultMessage: "Try again"
      });
    case _types.ReindexStatus.inProgress:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexButton.reindexingLabel",
        defaultMessage: "Reindexing\u2026"
      });
    case _types.ReindexStatus.paused:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexButton.resumeLabel",
        defaultMessage: "Resume reindexing"
      });
    case _types.ReindexStatus.cancelled:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexButton.restartLabel",
        defaultMessage: "Restart reindexing"
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexButton.runReindexLabel",
        defaultMessage: "Start reindexing"
      });
  }
};

/**
 * Displays a flyout that shows the current reindexing status for a given index.
 */
const ChecklistFlyoutStep = ({
  closeFlyout,
  reindexState,
  startReindex,
  cancelReindex
}) => {
  const {
    services: {
      api,
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  const {
    loadingState,
    status,
    hasRequiredPrivileges
  } = reindexState;
  const loading = loadingState === _types2.LoadingState.Loading || status === _types.ReindexStatus.inProgress;
  const isCompleted = status === _types.ReindexStatus.completed;
  const hasFetchFailed = status === _types.ReindexStatus.fetchFailed;
  const hasReindexingFailed = status === _types.ReindexStatus.failed;
  const {
    data: nodes
  } = api.useLoadNodeDiskSpace();
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, hasRequiredPrivileges === false && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.insufficientPrivilegeCallout.calloutTitle",
      defaultMessage: "You do not have sufficient privileges to reindex this index"
    }),
    color: "danger",
    iconType: "warning"
  })), nodes && nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    "data-test-subj": "lowDiskSpaceCallout",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.lowDiskSpaceCalloutTitle",
      defaultMessage: "Nodes with low disk space"
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.lowDiskSpaceCalloutDescription",
    defaultMessage: "Disk usage has exceeded the low watermark, which may prevent reindexing. The following nodes are impacted:"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("ul", null, nodes.map(({
    nodeName,
    available,
    nodeId
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: nodeId,
    "data-test-subj": "impactedNodeListItem"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.lowDiskSpaceUsedText",
    defaultMessage: "{nodeName} ({available} available)",
    values: {
      nodeName,
      available
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), (hasFetchFailed || hasReindexingFailed) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    "data-test-subj": hasFetchFailed ? 'fetchFailedCallout' : 'reindexingFailedCallout',
    title: hasFetchFailed ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.fetchFailedCalloutTitle",
      defaultMessage: "Reindex status not available"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexingFailedCalloutTitle",
      defaultMessage: "Reindexing error"
    })
  }, reindexState.errorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexDescription",
    defaultMessage: "The index will be read-only during reindexing. You won't be able to add, update, or delete documents until reindexing is complete. If you need to reindex to a new cluster, use the reindex API. {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: docLinks.links.upgradeAssistant.remoteReindex
      }, _i18n.i18n.translate('xpack.upgradeAssistant.checkupTab.reindexing.flyout.learnMoreLinkLabel', {
        defaultMessage: 'Learn more'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.readonlyCallout.backgroundResumeDetail",
    defaultMessage: "Reindexing is performed in the background. You can return to the Upgrade Assistant to view progress or resume reindexing after a Kibana restart."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_progress.ReindexProgress, {
    reindexState: reindexState,
    cancelReindex: cancelReindex
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.closeButtonLabel",
    defaultMessage: "Close"
  }))), !hasFetchFailed && !isCompleted && hasRequiredPrivileges && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: status === _types.ReindexStatus.paused ? 'warning' : 'primary',
    iconType: status === _types.ReindexStatus.paused ? 'play' : undefined,
    onClick: startReindex,
    isLoading: loading,
    disabled: loading || !hasRequiredPrivileges,
    "data-test-subj": "startReindexingButton"
  }, buttonLabel(status))))));
};
exports.ChecklistFlyoutStep = ChecklistFlyoutStep;