"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryBarMenuPanels = QueryBarMenuPanels;
exports.strings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _from_user = require("./from_user");
var _language_switcher = require("./language_switcher");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MAP_ITEMS_TO_FILTER_OPTION = {
  'filter-sets-pinAllFilters': 'pinFilter',
  'filter-sets-unpinAllFilters': 'pinFilter',
  'filter-sets-enableAllFilters': 'disableFilter',
  'filter-sets-disableAllFilters': 'disableFilter',
  'filter-sets-invertAllFilters': 'negateFilter',
  'filter-sets-removeAllFilters': 'deleteFilter'
};
const strings = {
  getLuceneLanguageName: () => _i18n.i18n.translate('unifiedSearch.query.queryBar.luceneLanguageName', {
    defaultMessage: 'Lucene'
  }),
  getKqlLanguageName: () => _i18n.i18n.translate('unifiedSearch.query.queryBar.kqlLanguageName', {
    defaultMessage: 'KQL'
  }),
  getOptionsAddFilterButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.addFilterButtonLabel', {
    defaultMessage: 'Add filter'
  }),
  getOptionsApplyAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.applyAllFiltersButtonLabel', {
    defaultMessage: 'Apply to all'
  }),
  getLoadOtherFilterSetLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.loadOtherFilterSetLabel', {
    defaultMessage: 'Load query'
  }),
  getLoadCurrentFilterSetLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.loadCurrentFilterSetLabel', {
    defaultMessage: 'Load query'
  }),
  getSaveAsNewFilterSetLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.saveAsNewFilterSetLabel', {
    defaultMessage: 'Save query'
  }),
  getSaveFilterSetLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.saveFilterSetLabel', {
    defaultMessage: 'Save query'
  }),
  getClearllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.clearllFiltersButtonLabel', {
    defaultMessage: 'Clear all'
  }),
  getSavedQueryPopoverSaveChangesButtonAriaLabel: title => _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverSaveChangesButtonAriaLabel', {
    defaultMessage: 'Save changes to {title}',
    values: {
      title
    }
  }),
  getSavedQueryPopoverSaveChangesButtonText: () => _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverSaveChangesButtonText', {
    defaultMessage: 'Update query'
  }),
  getSavedQueryPopoverSaveAsNewButtonAriaLabel: () => _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverSaveAsNewButtonAriaLabel', {
    defaultMessage: 'Save as new query'
  }),
  getSavedQueryPopoverSaveAsNewButtonText: () => _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverSaveAsNewButtonText', {
    defaultMessage: 'Save as new'
  }),
  getSaveCurrentFilterSetLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.saveCurrentFilterSetLabel', {
    defaultMessage: 'Save as new'
  }),
  getApplyAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.applyAllFiltersButtonLabel', {
    defaultMessage: 'Apply to all'
  }),
  getEnableAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.enableAllFiltersButtonLabel', {
    defaultMessage: 'Enable all'
  }),
  getDisableAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.disableAllFiltersButtonLabel', {
    defaultMessage: 'Disable all'
  }),
  getInvertNegatedFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.invertNegatedFiltersButtonLabel', {
    defaultMessage: 'Invert inclusion'
  }),
  getPinAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.pinAllFiltersButtonLabel', {
    defaultMessage: 'Pin all'
  }),
  getUnpinAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.unpinAllFiltersButtonLabel', {
    defaultMessage: 'Unpin all'
  }),
  getFilterLanguageLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.filterLanguageLabel', {
    defaultMessage: 'Filter language'
  })
};
exports.strings = strings;
function QueryBarMenuPanels({
  filters,
  savedQuery,
  language,
  dateRangeFrom,
  dateRangeTo,
  query,
  showSaveQuery,
  showFilterBar,
  showQueryInput,
  savedQueryService,
  saveAsNewQueryFormComponent,
  manageFilterSetComponent,
  hiddenPanelOptions,
  nonKqlMode,
  disableQueryLanguageSwitcher = false,
  closePopover,
  onQueryBarSubmit,
  onFiltersUpdated,
  onClearSavedQuery,
  onQueryChange,
  setRenderedComponent
}) {
  const kibana = (0, _public.useKibana)();
  const {
    appName,
    usageCollection,
    uiSettings,
    http,
    storage
  } = kibana.services;
  const reportUiCounter = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter.bind(usageCollection, appName);
  const cancelPendingListingRequest = (0, _react.useRef)(() => {});
  const [savedQueries, setSavedQueries] = (0, _react.useState)([]);
  const [hasFiltersOrQuery, setHasFiltersOrQuery] = (0, _react.useState)(false);
  const [savedQueryHasChanged, setSavedQueryHasChanged] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const fetchSavedQueries = async () => {
      cancelPendingListingRequest.current();
      let requestGotCancelled = false;
      cancelPendingListingRequest.current = () => {
        requestGotCancelled = true;
      };
      const {
        queries: savedQueryItems
      } = await savedQueryService.findSavedQueries('');
      if (requestGotCancelled) return;
      setSavedQueries(savedQueryItems.reverse().slice(0, 5));
    };
    if (showQueryInput && showFilterBar) {
      fetchSavedQueries();
    }
  }, [savedQueryService, savedQuery, showQueryInput, showFilterBar]);
  (0, _react.useEffect)(() => {
    if (savedQuery) {
      var _savedQuery$attribute, _savedQuery$attribute2, _savedQuery$attribute3, _savedQuery$attribute4;
      let filtersHaveChanged = (filters === null || filters === void 0 ? void 0 : filters.length) !== ((_savedQuery$attribute = savedQuery.attributes) === null || _savedQuery$attribute === void 0 ? void 0 : (_savedQuery$attribute2 = _savedQuery$attribute.filters) === null || _savedQuery$attribute2 === void 0 ? void 0 : _savedQuery$attribute2.length);
      if ((filters === null || filters === void 0 ? void 0 : filters.length) === ((_savedQuery$attribute3 = savedQuery.attributes) === null || _savedQuery$attribute3 === void 0 ? void 0 : (_savedQuery$attribute4 = _savedQuery$attribute3.filters) === null || _savedQuery$attribute4 === void 0 ? void 0 : _savedQuery$attribute4.length)) {
        filtersHaveChanged = Boolean(filters === null || filters === void 0 ? void 0 : filters.some((filter, index) => {
          var _savedQuery$attribute5, _savedQuery$attribute6, _savedQuery$attribute7;
          return !(0, _lodash.isEqual)(filter.query, (_savedQuery$attribute5 = savedQuery.attributes) === null || _savedQuery$attribute5 === void 0 ? void 0 : (_savedQuery$attribute6 = _savedQuery$attribute5.filters) === null || _savedQuery$attribute6 === void 0 ? void 0 : (_savedQuery$attribute7 = _savedQuery$attribute6[index]) === null || _savedQuery$attribute7 === void 0 ? void 0 : _savedQuery$attribute7.query);
        }));
      }
      if (filtersHaveChanged || !(0, _lodash.isEqual)(query, savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.query)) {
        setSavedQueryHasChanged(true);
      } else {
        setSavedQueryHasChanged(false);
      }
    }
  }, [filters, query, savedQuery, savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.filters, savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.query]);
  (0, _react.useEffect)(() => {
    const hasFilters = Boolean(filters && filters.length > 0);
    const hasQuery = Boolean(query && query.query);
    setHasFiltersOrQuery(hasFilters || hasQuery);
  }, [filters, onClearSavedQuery, query, savedQuery]);
  const getDateRange = () => {
    const defaultTimeSetting = uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS);
    return {
      from: dateRangeFrom || defaultTimeSetting.from,
      to: dateRangeTo || defaultTimeSetting.to
    };
  };
  const handleSave = (0, _react.useCallback)(() => {
    setRenderedComponent('saveForm');
  }, [setRenderedComponent]);
  const onEnableAll = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:enable_all`);
    const enabledFilters = filters === null || filters === void 0 ? void 0 : filters.map(_esQuery.enableFilter);
    if (enabledFilters) {
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(enabledFilters);
    }
  };
  const onDisableAll = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:disable_all`);
    const disabledFilters = filters === null || filters === void 0 ? void 0 : filters.map(_esQuery.disableFilter);
    if (disabledFilters) {
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(disabledFilters);
    }
  };
  const onToggleAllNegated = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:invert_all`);
    const negatedFilters = filters === null || filters === void 0 ? void 0 : filters.map(_esQuery.toggleFilterNegated);
    if (negatedFilters) {
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(negatedFilters);
    }
  };
  const onRemoveAll = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:remove_all`);
    onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated([]);
  };
  const onPinAll = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:pin_all`);
    const pinnedFilters = filters === null || filters === void 0 ? void 0 : filters.map(_esQuery.pinFilter);
    if (pinnedFilters) {
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(pinnedFilters);
    }
  };
  const onUnpinAll = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:unpin_all`);
    const unPinnedFilters = filters === null || filters === void 0 ? void 0 : filters.map(_esQuery.unpinFilter);
    if (unPinnedFilters) {
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(unPinnedFilters);
    }
  };
  const onQueryStringChange = value => {
    onQueryChange({
      query: {
        query: value,
        language
      },
      dateRange: getDateRange()
    });
  };
  const onSelectLanguage = lang => {
    http.post('/internal/kql_opt_in_stats', {
      version: _common.KQL_TELEMETRY_ROUTE_LATEST_VERSION,
      body: JSON.stringify({
        opt_in: lang === 'kuery'
      })
    });
    const storageKey = _common.KIBANA_USER_QUERY_LANGUAGE_KEY;
    storage.set(storageKey, lang);
    const newQuery = {
      query: '',
      language: lang
    };
    onQueryStringChange(newQuery.query);
    onQueryBarSubmit({
      query: {
        query: (0, _from_user.fromUser)(newQuery.query),
        language: newQuery.language
      },
      dateRange: getDateRange()
    });
  };
  const luceneLabel = strings.getLuceneLanguageName();
  const kqlLabel = strings.getKqlLanguageName();
  const filtersRelatedPanels = [{
    name: strings.getOptionsAddFilterButtonLabel(),
    icon: 'plus',
    onClick: () => {
      setRenderedComponent('addFilter');
    }
  }, {
    name: strings.getOptionsApplyAllFiltersButtonLabel(),
    icon: 'filter',
    panel: 2,
    disabled: !Boolean(filters && filters.length > 0),
    'data-test-subj': 'filter-sets-applyToAllFilters'
  }];
  const queryAndFiltersRelatedPanels = [{
    name: savedQuery ? strings.getLoadOtherFilterSetLabel() : strings.getLoadCurrentFilterSetLabel(),
    panel: 4,
    width: 350,
    icon: 'filter',
    'data-test-subj': 'saved-query-management-load-button',
    disabled: !savedQueries.length
  }, {
    name: savedQuery ? strings.getSaveAsNewFilterSetLabel() : strings.getSaveFilterSetLabel(),
    icon: 'save',
    disabled: !Boolean(showSaveQuery) || !hasFiltersOrQuery || savedQuery && !savedQueryHasChanged,
    panel: 1,
    'data-test-subj': 'saved-query-management-save-button'
  }, {
    isSeparator: true
  }];
  const items = [];
  // apply to all actions are only shown when there are filters
  if (showFilterBar) {
    items.push(...filtersRelatedPanels);
  }
  // clear all actions are only shown when there are filters or query
  if (showFilterBar || showQueryInput) {
    items.push({
      name: strings.getClearllFiltersButtonLabel(),
      disabled: !hasFiltersOrQuery && !Boolean(savedQuery),
      icon: 'cross',
      'data-test-subj': 'filter-sets-removeAllFilters',
      onClick: () => {
        closePopover();
        onQueryBarSubmit({
          query: {
            query: '',
            language
          },
          dateRange: getDateRange()
        });
        onRemoveAll();
        onClearSavedQuery === null || onClearSavedQuery === void 0 ? void 0 : onClearSavedQuery();
      }
    }, {
      isSeparator: true
    });
  }
  // saved queries actions are only shown when the showQueryInput and showFilterBar is true
  if (showQueryInput && showFilterBar) {
    items.push(...queryAndFiltersRelatedPanels);
  }

  // language menu appears when the showQueryInput is true
  if (showQueryInput && !disableQueryLanguageSwitcher) {
    items.push({
      name: `Language: ${language === 'kuery' ? kqlLabel : luceneLabel}`,
      panel: 3,
      'data-test-subj': 'switchQueryLanguageButton'
    });
  }
  let panels = [{
    id: 0,
    title: savedQuery !== null && savedQuery !== void 0 && savedQuery.attributes.title ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: savedQuery ? 'primary' : 'default',
      size: "s",
      "data-test-subj": "savedQueryTitle"
    }, /*#__PURE__*/_react.default.createElement("strong", null, savedQuery.attributes.title))), savedQuery && savedQueryHasChanged && Boolean(showSaveQuery) && hasFiltersOrQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      onClick: handleSave,
      "aria-label": strings.getSavedQueryPopoverSaveChangesButtonAriaLabel(savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.title),
      "data-test-subj": "saved-query-management-save-changes-button"
    }, strings.getSavedQueryPopoverSaveChangesButtonText())))) : undefined,
    items
  }, {
    id: 1,
    title: strings.getSaveCurrentFilterSetLabel(),
    disabled: !Boolean(showSaveQuery),
    content: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        padding: 16
      }
    }, saveAsNewQueryFormComponent)
  }, {
    id: 2,
    initialFocusedItemIndex: 1,
    title: strings.getApplyAllFiltersButtonLabel(),
    items: [{
      name: strings.getEnableAllFiltersButtonLabel(),
      icon: 'eye',
      'data-test-subj': 'filter-sets-enableAllFilters',
      onClick: () => {
        closePopover();
        onEnableAll();
      }
    }, {
      name: strings.getDisableAllFiltersButtonLabel(),
      'data-test-subj': 'filter-sets-disableAllFilters',
      icon: 'eyeClosed',
      onClick: () => {
        closePopover();
        onDisableAll();
      }
    }, {
      name: strings.getInvertNegatedFiltersButtonLabel(),
      'data-test-subj': 'filter-sets-invertAllFilters',
      icon: 'invert',
      onClick: () => {
        closePopover();
        onToggleAllNegated();
      }
    }, {
      name: strings.getPinAllFiltersButtonLabel(),
      'data-test-subj': 'filter-sets-pinAllFilters',
      icon: 'pin',
      onClick: () => {
        closePopover();
        onPinAll();
      }
    }, {
      name: strings.getUnpinAllFiltersButtonLabel(),
      'data-test-subj': 'filter-sets-unpinAllFilters',
      icon: 'pin',
      onClick: () => {
        closePopover();
        onUnpinAll();
      }
    }]
  }, {
    id: 3,
    title: strings.getFilterLanguageLabel(),
    content: /*#__PURE__*/_react.default.createElement(_language_switcher.QueryLanguageSwitcher, {
      language: language,
      onSelectLanguage: onSelectLanguage,
      nonKqlMode: nonKqlMode,
      isOnTopBarMenu: true,
      deps: {
        docLinks: kibana.services.docLinks
      }
    })
  }, {
    id: 4,
    title: strings.getLoadCurrentFilterSetLabel(),
    width: 400,
    content: /*#__PURE__*/_react.default.createElement("div", null, manageFilterSetComponent)
  }];
  if (hiddenPanelOptions && hiddenPanelOptions.length > 0) {
    panels = panels.map(panel => {
      var _panel$items;
      return {
        ...panel,
        items: (_panel$items = panel.items) === null || _panel$items === void 0 ? void 0 : _panel$items.filter(panelItem => {
          if (!panelItem['data-test-subj']) {
            return true;
          }
          const panelFilterOption = MAP_ITEMS_TO_FILTER_OPTION[panelItem['data-test-subj']];
          if (!panelFilterOption) {
            return true;
          }
          return !hiddenPanelOptions.includes(panelFilterOption);
        })
      };
    });
  }
  return panels;
}