"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldInput = FieldInput;
exports.strings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _eui = require("@elastic/eui");
var _filter_editor = require("../../filter_bar/filter_editor");
var _context = require("../context");
var _helpers = require("../../filter_bar/filter_editor/lib/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getFieldSelectPlaceholderLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.fieldSelectPlaceholder', {
    defaultMessage: 'Select a field'
  })
};
exports.strings = strings;
function FieldInput({
  field,
  dataView,
  onHandleField
}) {
  const {
    disabled,
    suggestionsAbstraction
  } = (0, _react.useContext)(_context.FiltersBuilderContextType);
  const fields = dataView ? (0, _filter_editor.getFilterableFields)(dataView) : [];
  const id = (0, _eui.useGeneratedHtmlId)({
    prefix: 'fieldInput'
  });
  const inputRef = (0, _react.useRef)(null);
  const onFieldChange = (0, _react.useCallback)(([selectedField]) => {
    onHandleField(selectedField);
  }, [onHandleField]);
  const getLabel = (0, _react.useCallback)(dataViewField => {
    let label = dataViewField.customLabel || dataViewField.name;
    if (suggestionsAbstraction !== null && suggestionsAbstraction !== void 0 && suggestionsAbstraction.fields[dataViewField.name]) {
      var _suggestionsAbstracti, _suggestionsAbstracti2;
      label = (_suggestionsAbstracti = suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : (_suggestionsAbstracti2 = suggestionsAbstraction.fields[dataViewField.name]) === null || _suggestionsAbstracti2 === void 0 ? void 0 : _suggestionsAbstracti2.displayField) !== null && _suggestionsAbstracti !== void 0 ? _suggestionsAbstracti : label;
    }
    return {
      label,
      value: dataViewField.type,
      prepend: /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
        type: dataViewField.type,
        fill: "none",
        className: "eui-alignMiddle"
      })
    };
  }, [suggestionsAbstraction]);
  const optionFields = fields.map(getLabel);
  const euiOptions = optionFields;
  const selectedEuiOptions = (field ? [field] : []).filter(option => fields.indexOf(option) !== -1).map(option => euiOptions[fields.indexOf(option)]);
  const onComboBoxChange = newOptions => {
    const newValues = newOptions.map(({
      label
    }) => fields[optionFields.findIndex(optionField => optionField.label === label)]);
    onFieldChange(newValues);
  };
  const panelMinWidth = (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(euiOptions, ['label']);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    id: id,
    inputRef: ref => {
      inputRef.current = ref;
    },
    options: euiOptions,
    selectedOptions: selectedEuiOptions,
    onChange: onComboBoxChange,
    isDisabled: disabled,
    placeholder: strings.getFieldSelectPlaceholderLabel(),
    sortMatchesBy: "startsWith",
    "aria-label": strings.getFieldSelectPlaceholderLabel(),
    isClearable: false,
    compressed: true,
    fullWidth: true,
    "data-test-subj": "filterFieldSuggestionList",
    singleSelection: _helpers.SINGLE_SELECTION_AS_TEXT_PROPS,
    truncationProps: _helpers.MIDDLE_TRUNCATION_PROPS,
    inputPopoverProps: {
      panelMinWidth
    }
  });
}