"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhrasesValuesInput = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _generic_combo_box = require("./generic_combo_box");
var _phrase_suggestor = require("./phrase_suggestor");
var _phrases_values_input = require("./phrases_values_input.styles");
var _helpers = require("./lib/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PhrasesValuesInputUI extends _phrase_suggestor.PhraseSuggestorUI {
  render() {
    const {
      suggestions,
      isLoading
    } = this.state;
    const {
      values,
      intl,
      onChange,
      fullWidth,
      onParamsUpdate,
      compressed,
      disabled
    } = this.props;
    const options = values ? (0, _lodash.uniq)([...values, ...suggestions]) : suggestions;
    const panelMinWidth = (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(options);
    return /*#__PURE__*/_react.default.createElement(StringComboBox, {
      async: true,
      isLoading: isLoading,
      fullWidth: fullWidth,
      compressed: compressed,
      placeholder: intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.valuesSelectPlaceholder',
        defaultMessage: 'Select values'
      }),
      "aria-label": intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.valuesSelectPlaceholder',
        defaultMessage: 'Select values'
      }),
      delimiter: ",",
      isCaseSensitive: true,
      options: options,
      getLabel: option => option,
      selectedOptions: values || [],
      onSearchChange: this.onSearchChange,
      onCreateOption: option => {
        onParamsUpdate(option.trim());
      },
      className: (0, _phrases_values_input.phrasesValuesComboboxCss)(this.props.theme),
      onChange: onChange,
      isClearable: false,
      "data-test-subj": "filterParamsComboBox phrasesParamsComboxBox",
      isDisabled: disabled,
      truncationProps: _helpers.MIDDLE_TRUNCATION_PROPS,
      inputPopoverProps: {
        panelMinWidth,
        anchorPosition: 'downRight'
      }
    });
  }
}
function StringComboBox(props) {
  return (0, _generic_combo_box.GenericComboBox)(props);
}
const PhrasesValuesInput = (0, _i18nReact.injectI18n)((0, _eui.withEuiTheme)((0, _public.withKibana)(PhrasesValuesInputUI)));
exports.PhrasesValuesInput = PhrasesValuesInput;