"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TextBasedLanguagesTransitionModal;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
function TextBasedLanguagesTransitionModal({
  closeModal,
  setIsTextLangTransitionModalVisible,
  textBasedLanguage
}) {
  const [dismissModalChecked, setDismissModalChecked] = (0, _react.useState)(false);
  const onTransitionModalDismiss = (0, _react.useCallback)(e => {
    setDismissModalChecked(e.target.checked);
  }, []);
  const language = (0, _esQuery.getLanguageDisplayName)(textBasedLanguage);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: () => setIsTextLangTransitionModalVisible(false),
    style: {
      width: 700
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.textBasedLanguagesTransitionModalTitle', {
    defaultMessage: 'Your query will be removed'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.textBasedLanguagesTransitionModalBody', {
    defaultMessage: "Switching data views removes the current {language} query. Save this search to ensure you don't lose work.",
    values: {
      language
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "dismiss-text-based-languages-transition-modal",
    label: _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.textBasedLanguagesTransitionModalDismissButton', {
      defaultMessage: "Don't show this warning again"
    }),
    checked: dismissModalChecked,
    onChange: onTransitionModalDismiss
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => closeModal(dismissModalChecked),
    color: "warning",
    iconType: "merge",
    "data-test-subj": "unifiedSearch_switch_noSave"
  }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.textBasedLanguagesTransitionModalCloseButton', {
    defaultMessage: 'Switch without saving'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => closeModal(dismissModalChecked, true),
    fill: true,
    color: "success",
    iconType: "save",
    "data-test-subj": "unifiedSearch_switch_andSave"
  }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.textBasedLanguagesTransitionModalSaveButton', {
    defaultMessage: 'Save and switch'
  }))))))));
}
module.exports = exports.default;