"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupGetOperatorSuggestions = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _query_suggestion_provider = require("../query_suggestion_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const equalsText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.equalOperatorDescription.equalsText",
  defaultMessage: "equals",
  description: "Part of unifiedSearch.kueryAutocomplete.equalOperatorDescription. Full text: 'equals some value'"
});
const lessThanOrEqualToText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.lessThanOrEqualOperatorDescription.lessThanOrEqualToText",
  defaultMessage: "less than or equal to",
  description: "Part of unifiedSearch.kueryAutocomplete.lessThanOrEqualOperatorDescription. Full text: 'is less than or equal to some value'"
});
const greaterThanOrEqualToText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.greaterThanOrEqualOperatorDescription.greaterThanOrEqualToText",
  defaultMessage: "greater than or equal to",
  description: "Part of unifiedSearch.kueryAutocomplete.greaterThanOrEqualOperatorDescription. Full text: 'is greater than or equal to some value'"
});
const lessThanText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.lessThanOperatorDescription.lessThanText",
  defaultMessage: "less than",
  description: "Part of unifiedSearch.kueryAutocomplete.lessThanOperatorDescription. Full text: 'is less than some value'"
});
const greaterThanText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.greaterThanOperatorDescription.greaterThanText",
  defaultMessage: "greater than",
  description: "Part of unifiedSearch.kueryAutocomplete.greaterThanOperatorDescription. Full text: 'is greater than some value'"
});
const existsText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.existOperatorDescription.existsText",
  defaultMessage: "exists",
  description: "Part of unifiedSearch.kueryAutocomplete.existOperatorDescription. Full text: 'exists in any form'"
});
const operators = {
  ':': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.equalOperatorDescription",
      defaultMessage: "{equals} some value",
      values: {
        equals: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout"
        }, equalsText)
      },
      description: "Full text: 'equals some value'. See 'unifiedSearch.kueryAutocomplete.equalOperatorDescription.equalsText' for 'equals' part."
    }),
    fieldTypes: ['string', 'number', 'number_range', 'date', 'date_range', 'ip', 'ip_range', 'geo_point', 'geo_shape', 'boolean']
  },
  '<=': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.lessThanOrEqualOperatorDescription",
      defaultMessage: "is {lessThanOrEqualTo} some value",
      values: {
        lessThanOrEqualTo: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout"
        }, lessThanOrEqualToText)
      },
      description: "Full text: 'is less than or equal to some value'. See 'unifiedSearch.kueryAutocomplete.lessThanOrEqualOperatorDescription.lessThanOrEqualToText' for 'less than or equal to' part."
    }),
    fieldTypes: ['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range']
  },
  '>=': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.greaterThanOrEqualOperatorDescription",
      defaultMessage: "is {greaterThanOrEqualTo} some value",
      values: {
        greaterThanOrEqualTo: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout"
        }, greaterThanOrEqualToText)
      },
      description: "Full text: 'is greater than or equal to some value'. See 'unifiedSearch.kueryAutocomplete.greaterThanOrEqualOperatorDescription.greaterThanOrEqualToText' for 'greater than or equal to' part."
    }),
    fieldTypes: ['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range']
  },
  '<': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.lessThanOperatorDescription",
      defaultMessage: "is {lessThan} some value",
      values: {
        lessThan: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout"
        }, lessThanText)
      },
      description: "Full text: 'is less than some value'. See 'unifiedSearch.kueryAutocomplete.lessThanOperatorDescription.lessThanText' for 'less than' part."
    }),
    fieldTypes: ['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range']
  },
  '>': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.greaterThanOperatorDescription",
      defaultMessage: "is {greaterThan} some value",
      values: {
        greaterThan: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout"
        }, greaterThanText)
      },
      description: "Full text: 'is greater than some value'. See 'unifiedSearch.kueryAutocomplete.greaterThanOperatorDescription.greaterThanText' for 'greater than' part."
    }),
    fieldTypes: ['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range']
  },
  ': *': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.existOperatorDescription",
      defaultMessage: "{exists} in any form",
      values: {
        exists: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout"
        }, existsText)
      },
      description: "Full text: 'exists in any form'. See 'unifiedSearch.kueryAutocomplete.existOperatorDescription.existsText' for 'exists' part."
    }),
    fieldTypes: undefined
  }
};
const getOperatorByName = operator => operators[operator];
const getDescription = operator => /*#__PURE__*/_react.default.createElement("p", null, getOperatorByName(operator).description);
const setupGetOperatorSuggestions = () => {
  return ({
    indexPatterns
  }, {
    end,
    fieldName,
    nestedPath
  }) => {
    const allFields = (0, _lodash.flatten)(indexPatterns.map(indexPattern => {
      return indexPattern.fields.slice();
    }));
    const fullFieldName = nestedPath ? `${nestedPath}.${fieldName}` : fieldName;
    const fields = allFields.filter(field => field.name === fullFieldName).map(field => {
      const matchingOperators = Object.keys(operators).filter(operator => {
        const {
          fieldTypes
        } = getOperatorByName(operator);
        return !fieldTypes || fieldTypes.includes(field.type);
      });
      const suggestions = matchingOperators.map(operator => ({
        type: _query_suggestion_provider.QuerySuggestionTypes.Operator,
        text: operator + ' ',
        description: getDescription(operator),
        start: end,
        end
      }));
      return suggestions;
    });
    return Promise.resolve((0, _lodash.flatten)(fields));
  };
};
exports.setupGetOperatorSuggestions = setupGetOperatorSuggestions;