"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ThresholdExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _constants = require("../constants");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThresholdExpression = ({
  thresholdComparator,
  errors,
  onChangeSelectedThresholdComparator,
  onChangeSelectedThreshold,
  customComparators,
  display = 'inline',
  threshold = [],
  popupPosition,
  unit = ''
}) => {
  const comparators = customComparators !== null && customComparators !== void 0 ? customComparators : _constants.builtInComparators;
  const [alertThresholdPopoverOpen, setAlertThresholdPopoverOpen] = (0, _react.useState)(false);
  const [comparator, setComparator] = (0, _react.useState)(thresholdComparator);
  const [numRequiredThresholds, setNumRequiredThresholds] = (0, _react.useState)(comparators[thresholdComparator].requiredValues);
  const andThresholdText = _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.threshold.andLabel', {
    defaultMessage: 'AND'
  });
  (0, _react.useEffect)(() => {
    const updateThresholdValue = comparators[comparator].requiredValues !== numRequiredThresholds;
    if (updateThresholdValue) {
      const thresholdValues = threshold.slice(0, comparators[comparator].requiredValues);
      onChangeSelectedThreshold(thresholdValues);
      setNumRequiredThresholds(comparators[comparator].requiredValues);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [comparator]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "thresholdPopover",
      description: comparators[comparator].text,
      value: (threshold || []).slice(0, numRequiredThresholds).join(` ${andThresholdText} `) + unit,
      isActive: Boolean(alertThresholdPopoverOpen || errors.threshold0 && errors.threshold0.length || errors.threshold1 && errors.threshold1.length),
      onClick: () => {
        setAlertThresholdPopoverOpen(true);
      },
      display: display === 'inline' ? 'inline' : 'columns',
      isInvalid: errors.threshold0 && errors.threshold0.length || (errors.threshold1 && errors.threshold1.length) > 0 ? true : false
    }),
    isOpen: alertThresholdPopoverOpen,
    closePopover: () => {
      setAlertThresholdPopoverOpen(false);
    },
    ownFocus: true,
    display: display === 'fullWidth' ? 'block' : 'inline-block',
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downLeft',
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_components.ClosablePopoverTitle, {
    onClose: () => setAlertThresholdPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, comparators[comparator].text)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "comparatorOptionsComboBox",
    value: comparator,
    onChange: e => {
      setComparator(e.target.value);
      onChangeSelectedThresholdComparator(e.target.value);
    },
    options: Object.values(comparators).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    })
  })), Array.from(Array(numRequiredThresholds)).map((_notUsed, i) => {
    var _errors, _errors2;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `threshold${i}`
    }, i > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "watcherThresholdWatchInBetweenComparatorText"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, andThresholdText)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      isInvalid: ((_errors = errors[`threshold${i}`]) === null || _errors === void 0 ? void 0 : _errors.length) > 0 || (0, _lodash.isNil)(threshold[i]),
      error: errors[`threshold${i}`]
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": "alertThresholdInput",
      min: 0,
      value: !threshold || threshold[i] === undefined ? '' : threshold[i],
      isInvalid: ((_errors2 = errors[`threshold${i}`]) === null || _errors2 === void 0 ? void 0 : _errors2.length) > 0 || (0, _lodash.isNil)(threshold[i]),
      onChange: e => {
        const {
          value
        } = e.target;
        const thresholdVal = value !== '' ? parseFloat(value) : undefined;
        const newThreshold = [...threshold];
        if (thresholdVal !== undefined) {
          newThreshold[i] = thresholdVal;
        } else {
          delete newThreshold[i];
        }
        onChangeSelectedThreshold(newThreshold);
      }
    }))));
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ThresholdExpression = ThresholdExpression;