"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.futureTimeToInterval = exports.default = exports.RuleStatusDropdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/alerting-plugin/common");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
var _rule_snooze = require("./rule_snooze");
var _lib = require("../../../lib");
var _toast_with_circuit_breaker_content = require("../../../components/toast_with_circuit_breaker_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SNOOZE_END_TIME_FORMAT = 'LL @ LT';
const RuleStatusDropdown = ({
  rule,
  onRuleChanged,
  disableRule,
  enableRule,
  snoozeRule,
  unsnoozeRule,
  isEditable,
  hideSnoozeOption = false,
  direction = 'column'
}) => {
  const [isEnabled, setIsEnabled] = (0, _react.useState)(rule.enabled);
  const [isSnoozed, setIsSnoozed] = (0, _react.useState)(!hideSnoozeOption && (0, _lib.isRuleSnoozed)(rule));
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    setIsEnabled(rule.enabled);
  }, [rule.enabled]);
  (0, _react.useEffect)(() => {
    if (!hideSnoozeOption) setIsSnoozed((0, _lib.isRuleSnoozed)(rule));
  }, [rule, hideSnoozeOption]);
  const [isUpdating, setIsUpdating] = (0, _react.useState)(false);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onClickBadge = (0, _react.useCallback)(() => setIsPopoverOpen(isOpen => !isOpen), [setIsPopoverOpen]);
  const onClosePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), [setIsPopoverOpen]);
  const enableRuleInternal = (0, _react.useCallback)(async () => {
    const {
      errors
    } = await enableRule();
    if (!errors.length) {
      return;
    }
    const message = (0, _common.parseRuleCircuitBreakerErrorMessage)(errors[0].message);
    toasts.addDanger({
      title: message.summary,
      ...(message.details && {
        text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_toast_with_circuit_breaker_content.ToastWithCircuitBreakerContent, null, message.details))
      })
    });
    throw new Error();
  }, [enableRule, toasts]);
  const onChangeEnabledStatus = (0, _react.useCallback)(async enable => {
    if (rule.enabled === enable) {
      return;
    }
    setIsUpdating(true);
    try {
      if (enable) {
        await enableRuleInternal();
      } else {
        await disableRule();
      }
      setIsEnabled(!isEnabled);
      onRuleChanged();
    } finally {
      setIsUpdating(false);
    }
  }, [rule.enabled, isEnabled, onRuleChanged, enableRuleInternal, disableRule]);
  const onSnoozeRule = (0, _react.useCallback)(async snoozeSchedule => {
    try {
      await snoozeRule(snoozeSchedule);
      onRuleChanged();
    } finally {
      onClosePopover();
    }
  }, [snoozeRule, onRuleChanged, onClosePopover]);
  const onUnsnoozeRule = (0, _react.useCallback)(async scheduleIds => {
    try {
      await unsnoozeRule(scheduleIds);
      onRuleChanged();
    } finally {
      onClosePopover();
    }
  }, [unsnoozeRule, onRuleChanged, onClosePopover]);
  const badgeColor = !isEnabled ? 'default' : isSnoozed ? 'warning' : 'primary';
  const badgeMessage = !isEnabled ? DISABLED : isSnoozed ? SNOOZED : ENABLED;
  const remainingSnoozeTime = isEnabled && isSnoozed ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: rule.muteAll ? INDEFINITELY : (0, _moment.default)(new Date(rule.isSnoozedUntil)).format(SNOOZE_END_TIME_FORMAT)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, rule.muteAll ? INDEFINITELY : (0, _moment.default)(new Date(rule.isSnoozedUntil)).fromNow(true))) : null;
  const nonEditableBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: badgeColor,
    "data-test-subj": "statusDropdownReadonly"
  }, badgeMessage);
  const editableBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: badgeColor,
    iconSide: "right",
    iconType: !isUpdating && isEditable ? 'arrowDown' : undefined,
    onClick: onClickBadge,
    iconOnClick: onClickBadge,
    onClickAriaLabel: OPEN_MENU_ARIA_LABEL,
    iconOnClickAriaLabel: OPEN_MENU_ARIA_LABEL,
    isDisabled: isUpdating
  }, badgeMessage, isUpdating && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    style: {
      marginLeft: '4px',
      marginRight: '4px'
    },
    size: "s"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: direction,
    alignItems: direction === 'row' ? 'center' : 'flexStart',
    justifyContent: "flexStart",
    gutterSize: direction === 'row' ? 's' : 'xs',
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isEditable ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: editableBadge,
    isOpen: isPopoverOpen && isEditable,
    closePopover: onClosePopover,
    panelPaddingSize: "s",
    "data-test-subj": "statusDropdown",
    title: badgeMessage
  }, /*#__PURE__*/_react.default.createElement(RuleStatusMenu, {
    onClosePopover: onClosePopover,
    onChangeEnabledStatus: onChangeEnabledStatus,
    isEnabled: isEnabled,
    isSnoozed: isSnoozed,
    snoozeEndTime: rule.isSnoozedUntil,
    hideSnoozeOption: hideSnoozeOption,
    snoozeRule: onSnoozeRule,
    unsnoozeRule: onUnsnoozeRule,
    scheduledSnoozes: rule.snoozeSchedule,
    activeSnoozes: rule.activeSnoozes
  })) : nonEditableBadge), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "remainingSnoozeTime",
    grow: false
  }, remainingSnoozeTime));
};
exports.default = exports.RuleStatusDropdown = RuleStatusDropdown;
const RuleStatusMenu = ({
  onChangeEnabledStatus,
  onClosePopover,
  isEnabled,
  isSnoozed,
  snoozeEndTime,
  hideSnoozeOption = false,
  snoozeRule,
  unsnoozeRule,
  scheduledSnoozes = [],
  activeSnoozes = []
}) => {
  const enableRule = (0, _react.useCallback)(() => {
    if (isSnoozed) {
      // Unsnooze if the rule is snoozed and the user clicks Enabled
      unsnoozeRule();
    } else {
      onChangeEnabledStatus(true);
    }
    onClosePopover();
  }, [onChangeEnabledStatus, onClosePopover, unsnoozeRule, isSnoozed]);
  const disableRule = (0, _react.useCallback)(() => {
    onChangeEnabledStatus(false);
    onClosePopover();
  }, [onChangeEnabledStatus, onClosePopover]);
  let snoozeButtonTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, SNOOZE);
  if (isSnoozed && snoozeEndTime) {
    snoozeButtonTitle = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, SNOOZE), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, (0, _moment.default)(snoozeEndTime).format(SNOOZE_END_TIME_FORMAT)));
  }
  const getSnoozeMenuItem = () => {
    if (!hideSnoozeOption) {
      return [{
        name: snoozeButtonTitle,
        icon: isEnabled && isSnoozed ? 'check' : 'empty',
        panel: 1,
        disabled: !isEnabled,
        'data-test-subj': 'statusDropdownSnoozeItem'
      }];
    }
    return [];
  };
  const getSnoozePanel = () => {
    if (!hideSnoozeOption) {
      return [{
        id: 1,
        width: 400,
        title: SNOOZE,
        content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          paddingSize: "none",
          hasShadow: false
        }, /*#__PURE__*/_react.default.createElement(_rule_snooze.SnoozePanel, {
          interval: futureTimeToInterval(snoozeEndTime),
          showCancel: isSnoozed,
          snoozeRule: snoozeRule,
          unsnoozeRule: unsnoozeRule,
          scheduledSnoozes: scheduledSnoozes,
          activeSnoozes: activeSnoozes,
          hasTitle: false
        }))
      }];
    }
    return [];
  };
  const panels = [{
    id: 0,
    width: 360,
    items: [{
      name: ENABLED,
      icon: isEnabled && !isSnoozed ? 'check' : 'empty',
      onClick: enableRule,
      'data-test-subj': 'statusDropdownEnabledItem'
    }, {
      name: DISABLED,
      icon: !isEnabled ? 'check' : 'empty',
      onClick: disableRule,
      'data-test-subj': 'statusDropdownDisabledItem'
    }, ...getSnoozeMenuItem()]
  }, ...getSnoozePanel()];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    "data-test-subj": "ruleStatusMenu",
    initialPanelId: 0,
    panels: panels
  });
};
const futureTimeToInterval = time => {
  if (!time) return;
  const relativeTime = (0, _moment.default)(time).locale('en').fromNow(true);
  const [valueStr, unitStr] = relativeTime.split(' ');
  let value = valueStr === 'a' || valueStr === 'an' ? 1 : parseInt(valueStr, 10);
  let unit;
  switch (unitStr) {
    case 'year':
    case 'years':
      unit = 'M';
      value = value * 12;
      break;
    case 'month':
    case 'months':
      unit = 'M';
      break;
    case 'day':
    case 'days':
      unit = 'd';
      break;
    case 'hour':
    case 'hours':
      unit = 'h';
      break;
    case 'minute':
    case 'minutes':
      unit = 'm';
      break;
  }
  if (!unit) return;
  return `${value}${unit}`;
};
exports.futureTimeToInterval = futureTimeToInterval;
const ENABLED = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.enabledRuleStatus', {
  defaultMessage: 'Enabled'
});
const DISABLED = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.disabledRuleStatus', {
  defaultMessage: 'Disabled'
});
const SNOOZED = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozedRuleStatus', {
  defaultMessage: 'Snoozed'
});
const SNOOZE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeMenuTitle', {
  defaultMessage: 'Snooze'
});
const OPEN_MENU_ARIA_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleStatusDropdownMenuLabel', {
  defaultMessage: 'Change rule status or snooze'
});
const INDEFINITELY = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.remainingSnoozeIndefinite', {
  defaultMessage: 'Indefinitely'
});

// eslint-disable-next-line import/no-default-export