"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkSnoozeModalWithApi = exports.BulkSnoozeModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _rule_snooze = require("./rule_snooze");
var _use_bulk_edit_response = require("../../../hooks/use_bulk_edit_response");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const failureMessage = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkSnoozeFailMessage', {
  defaultMessage: 'Failed to bulk snooze rules'
});
const deleteConfirmPlural = total => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkUnsnoozeConfirmationPlural', {
  defaultMessage: 'Unsnooze {total, plural, one {# rule} other {# rules}}? ',
  values: {
    total
  }
});
const deleteConfirmSingle = ruleName => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkUnsnoozeConfirmationSingle', {
  defaultMessage: 'Unsnooze {ruleName}?',
  values: {
    ruleName
  }
});
const BulkSnoozeModal = props => {
  const {
    bulkEditAction,
    rules,
    filter,
    numberOfSelectedRules = 0,
    onClose,
    onSave,
    setIsBulkEditing,
    onSearchPopulate,
    bulkSnoozeRules,
    bulkUnsnoozeRules
  } = props;
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    showToast
  } = (0, _use_bulk_edit_response.useBulkEditResponse)({
    onSearchPopulate
  });
  const interval = (0, _react.useMemo)(() => {
    if (filter) {
      return;
    }
    const rule = rules.find(item => item.isSnoozedUntil);
    if (rule) {
      return (0, _rule_snooze.futureTimeToInterval)(rule.isSnoozedUntil);
    }
  }, [rules, filter]);
  const onSnoozeRule = async schedule => {
    onClose();
    setIsBulkEditing(true);
    try {
      const response = await bulkSnoozeRules({
        ids: rules.map(item => item.id),
        filter,
        snoozeSchedule: schedule
      });
      showToast(response, 'snooze');
    } catch (error) {
      toasts.addError(error, {
        title: failureMessage
      });
    }
    setIsBulkEditing(false);
    onSave();
  };
  const onUnsnoozeRule = async () => {
    onClose();
    setIsBulkEditing(true);
    try {
      const response = await bulkUnsnoozeRules({
        ids: rules.map(item => item.id),
        filter
      });
      showToast(response, 'snooze');
    } catch (error) {
      toasts.addError(error, {
        title: failureMessage
      });
    }
    setIsBulkEditing(false);
    onSave();
  };
  const confirmationTitle = (0, _react.useMemo)(() => {
    if (!filter && numberOfSelectedRules === 1 && rules[0]) {
      return deleteConfirmSingle(rules[0].name);
    }
    return deleteConfirmPlural(numberOfSelectedRules);
  }, [rules, filter, numberOfSelectedRules]);
  if (bulkEditAction === 'unsnooze' && (rules.length || filter)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: confirmationTitle,
      onCancel: onClose,
      onConfirm: onUnsnoozeRule,
      confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkUnsnoozeConfirmButton', {
        defaultMessage: 'Unsnooze'
      }),
      cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkUnsnoozeCancelButton', {
        defaultMessage: 'Cancel'
      }),
      buttonColor: "danger",
      defaultFocusedButton: "confirm",
      "data-test-subj": "bulkUnsnoozeConfirmationModal"
    });
  }
  if (bulkEditAction === 'snooze' && (rules.length || filter)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.bulkSnoozeModal.modalTitle",
      defaultMessage: "Add snooze now"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_rule_snooze.SnoozePanel, {
      hasTitle: false,
      showCancel: false,
      showAddSchedule: false,
      interval: interval,
      snoozeRule: onSnoozeRule,
      unsnoozeRule: onUnsnoozeRule,
      scheduledSnoozes: [],
      activeSnoozes: []
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onClose
    }, "Close")));
  }
  return null;
};
exports.BulkSnoozeModal = BulkSnoozeModal;
const BulkSnoozeModalWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(BulkSnoozeModal);
exports.BulkSnoozeModalWithApi = BulkSnoozeModalWithApi;