"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialInterval = getInitialInterval;
var _common = require("@kbn/alerting-plugin/common");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInitialInterval(minimumScheduleInterval) {
  if (minimumScheduleInterval) {
    // return minimum schedule interval if it is larger than the default
    if ((0, _common.parseDuration)(minimumScheduleInterval) > (0, _common.parseDuration)(_constants.DEFAULT_RULE_INTERVAL)) {
      return minimumScheduleInterval;
    }
  }
  return _constants.DEFAULT_RULE_INTERVAL;
}