"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewInApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _Option = require("fp-ts/lib/Option");
var _pipeable = require("fp-ts/lib/pipeable");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_NAVIGATION = false;
const ViewInApp = ({
  rule
}) => {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    alerting: maybeAlerting
  } = (0, _kibana.useKibana)().services;
  const [ruleNavigation, setRuleNavigation] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    (0, _pipeable.pipe)((0, _Option.fromNullable)(maybeAlerting), (0, _Option.fold)(
    /**
     * If the ruleing plugin is disabled,
     * navigation isn't supported
     */
    () => setRuleNavigation(NO_NAVIGATION), ruleing => {
      return ruleing.getNavigation(rule.id).then(nav => nav ? setRuleNavigation(nav) : setRuleNavigation(NO_NAVIGATION)).catch(() => {
        setRuleNavigation(NO_NAVIGATION);
      });
    }));
  }, [rule.id, maybeAlerting]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "ruleDetails-viewInApp",
    isLoading: ruleNavigation === null,
    disabled: !hasNavigation(ruleNavigation),
    iconType: "popout"
  }, getNavigationHandler(ruleNavigation, rule, navigateToUrl, basePath)), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.viewRuleInAppButtonLabel",
    defaultMessage: "View in app"
  }));
};
exports.ViewInApp = ViewInApp;
function hasNavigation(ruleNavigation) {
  return typeof ruleNavigation === 'string';
}
function getNavigationHandler(ruleNavigation, rule, navigateToUrl, basePath) {
  return hasNavigation(ruleNavigation) ? {
    onClick: () => {
      navigateToUrl(basePath.prepend(ruleNavigation));
    }
  } : {};
}