"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withBulkRuleOperations = withBulkRuleOperations;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _health = require("../../../lib/rule_api/health");
var _clone = require("../../../lib/rule_api/clone");
var _get_rule = require("../../../lib/rule_api/get_rule");
var _rule_summary = require("../../../lib/rule_api/rule_summary");
var _mute_alert = require("../../../lib/rule_api/mute_alert");
var _rule_types = require("../../../lib/rule_api/rule_types");
var _load_execution_log_aggregations = require("../../../lib/rule_api/load_execution_log_aggregations");
var _mute = require("../../../lib/rule_api/mute");
var _unmute = require("../../../lib/rule_api/unmute");
var _state = require("../../../lib/rule_api/state");
var _load_execution_kpi_aggregations = require("../../../lib/rule_api/load_execution_kpi_aggregations");
var _load_global_execution_kpi_aggregations = require("../../../lib/rule_api/load_global_execution_kpi_aggregations");
var _load_action_error_log = require("../../../lib/rule_api/load_action_error_log");
var _unmute_alert = require("../../../lib/rule_api/unmute_alert");
var _resolve_rule = require("../../../lib/rule_api/resolve_rule");
var _snooze = require("../../../lib/rule_api/snooze");
var _unsnooze = require("../../../lib/rule_api/unsnooze");
var _bulk_delete = require("../../../lib/rule_api/bulk_delete");
var _bulk_enable = require("../../../lib/rule_api/bulk_enable");
var _bulk_disable = require("../../../lib/rule_api/bulk_disable");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function withBulkRuleOperations(WrappedComponent) {
  return props => {
    const {
      http
    } = (0, _kibana.useKibana)().services;
    return /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({}, props, {
      muteRules: async items => (0, _mute.muteRules)({
        http,
        ids: items.filter(item => !isRuleMuted(item)).map(item => item.id)
      }),
      unmuteRules: async items => (0, _unmute.unmuteRules)({
        http,
        ids: items.filter(isRuleMuted).map(item => item.id)
      }),
      muteRule: async rule => {
        if (!isRuleMuted(rule)) {
          return await (0, _mute.muteRule)({
            http,
            id: rule.id
          });
        }
      },
      unmuteRule: async rule => {
        if (isRuleMuted(rule)) {
          return await (0, _unmute.unmuteRule)({
            http,
            id: rule.id
          });
        }
      },
      muteAlertInstance: async (rule, instanceId) => {
        if (!isAlertInstanceMuted(rule, instanceId)) {
          return (0, _mute_alert.muteAlertInstance)({
            http,
            id: rule.id,
            instanceId
          });
        }
      },
      unmuteAlertInstance: async (rule, instanceId) => {
        if (isAlertInstanceMuted(rule, instanceId)) {
          return (0, _unmute_alert.unmuteAlertInstance)({
            http,
            id: rule.id,
            instanceId
          });
        }
      },
      loadRule: async ruleId => (0, _get_rule.loadRule)({
        http,
        ruleId
      }),
      loadRuleState: async ruleId => (0, _state.loadRuleState)({
        http,
        ruleId
      }),
      loadRuleSummary: async (ruleId, numberOfExecutions) => (0, _rule_summary.loadRuleSummary)({
        http,
        ruleId,
        numberOfExecutions
      }),
      loadRuleTypes: async () => (0, _rule_types.loadRuleTypes)({
        http
      }),
      loadExecutionLogAggregations: async loadProps => (0, _load_execution_log_aggregations.loadExecutionLogAggregations)({
        ...loadProps,
        http
      }),
      loadGlobalExecutionLogAggregations: async loadProps => (0, _load_execution_log_aggregations.loadGlobalExecutionLogAggregations)({
        ...loadProps,
        http
      }),
      loadActionErrorLog: async loadProps => (0, _load_action_error_log.loadActionErrorLog)({
        ...loadProps,
        http
      }),
      loadExecutionKPIAggregations: async loadExecutionKPIAggregationProps => (0, _load_execution_kpi_aggregations.loadExecutionKPIAggregations)({
        ...loadExecutionKPIAggregationProps,
        http
      }),
      loadGlobalExecutionKPIAggregations: async loadGlobalExecutionKPIAggregationsProps => (0, _load_global_execution_kpi_aggregations.loadGlobalExecutionKPIAggregations)({
        ...loadGlobalExecutionKPIAggregationsProps,
        http
      }),
      resolveRule: async ruleId => (0, _resolve_rule.resolveRule)({
        http,
        ruleId
      }),
      getHealth: async () => (0, _health.alertingFrameworkHealth)({
        http
      }),
      snoozeRule: async (rule, snoozeSchedule) => {
        return await (0, _snooze.snoozeRule)({
          http,
          id: rule.id,
          snoozeSchedule
        });
      },
      bulkSnoozeRules: async bulkSnoozeRulesProps => {
        return await (0, _snooze.bulkSnoozeRules)({
          http,
          ...bulkSnoozeRulesProps
        });
      },
      unsnoozeRule: async (rule, scheduleIds) => {
        return await (0, _unsnooze.unsnoozeRule)({
          http,
          id: rule.id,
          scheduleIds
        });
      },
      bulkUnsnoozeRules: async bulkUnsnoozeRulesProps => {
        return await (0, _unsnooze.bulkUnsnoozeRules)({
          http,
          ...bulkUnsnoozeRulesProps
        });
      },
      cloneRule: async ruleId => {
        return await (0, _clone.cloneRule)({
          http,
          ruleId
        });
      },
      bulkDeleteRules: async bulkDeleteProps => {
        return await (0, _bulk_delete.bulkDeleteRules)({
          http,
          ...bulkDeleteProps
        });
      },
      bulkEnableRules: async bulkEnableProps => {
        return await (0, _bulk_enable.bulkEnableRules)({
          http,
          ...bulkEnableProps
        });
      },
      bulkDisableRules: async bulkDisableProps => {
        return await (0, _bulk_disable.bulkDisableRules)({
          http,
          ...bulkDisableProps
        });
      }
    }));
  };
}
function isRuleMuted(rule) {
  return rule.muteAll === true;
}
function isAlertInstanceMuted(rule, instanceId) {
  return rule.mutedInstanceIds.findIndex(muted => muted === instanceId) >= 0;
}