"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RefineSearchPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_VISIBLE_THRESHOLD = 1000;
const RefineSearchPrompt = props => {
  const {
    documentSize = 0,
    visibleDocumentSize = DEFAULT_VISIBLE_THRESHOLD,
    backToTopAnchor
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const textStyles = (0, _react.useMemo)(() => ({
    backgroundColor: euiTheme.colors.lightestShade,
    padding: `${euiTheme.size.m} ${euiTheme.size.base}`,
    marginTop: `${euiTheme.size.xs}`
  }), [euiTheme]);
  if (documentSize < visibleDocumentSize) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: textStyles,
    textAlign: "center",
    size: "s",
    "data-test-subj": "refineSearchPrompt"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.refineSearchPrompt.prompt",
    defaultMessage: "These are the first {visibleDocumentSize} documents matching your search, refine your search to see others.",
    values: {
      visibleDocumentSize
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `#${backToTopAnchor}`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.refineSearchPrompt.backToTop",
    defaultMessage: "Back to top."
  })));
};
exports.RefineSearchPrompt = RefineSearchPrompt;