"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LastUpdatedAt = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Updated = /*#__PURE__*/_react.default.memo(({
  date,
  prefix,
  updatedAt
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, prefix, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
  "data-test-subj": "last-updated-at-date",
  key: `formatedRelative-${date}`,
  value: new Date(updatedAt)
})));
Updated.displayName = 'Updated';
const prefix = ` ${i18n.UPDATED} `;
const LastUpdatedAt = /*#__PURE__*/_react.default.memo(({
  compact = false,
  updatedAt,
  showUpdating = false
}) => {
  const [date, setDate] = (0, _react.useState)(Date.now());
  function tick() {
    setDate(Date.now());
  }
  (0, _react.useEffect)(() => {
    const timerID = setInterval(() => tick(), 10000);
    return () => {
      clearInterval(timerID);
    };
  }, []);
  const updateText = (0, _react.useMemo)(() => {
    if (showUpdating) {
      return /*#__PURE__*/_react.default.createElement("span", null, " ", i18n.UPDATING);
    }
    if (!compact) {
      return /*#__PURE__*/_react.default.createElement(Updated, {
        date: date,
        prefix: prefix,
        updatedAt: updatedAt
      });
    }
    return null;
  }, [compact, date, showUpdating, updatedAt]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(Updated, {
      date: date,
      prefix: prefix,
      updatedAt: updatedAt
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "toolbar-updated-at"
  }, updateText));
});
exports.default = exports.LastUpdatedAt = LastUpdatedAt;
LastUpdatedAt.displayName = 'LastUpdatedAt';

// eslint-disable-next-line import/no-default-export