"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLeadingControlColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _components = require("./components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLeadingControlColumn = () => ({
  id: 'bulkActions',
  width: 30,
  headerCellRender: () => {
    return /*#__PURE__*/_react.default.createElement(_components.BulkActionsHeader, null);
  },
  rowCellRender: cveProps => {
    const {
      visibleRowIndex: rowIndex
    } = cveProps;
    return /*#__PURE__*/_react.default.createElement(_components.BulkActionsRowCell, {
      rowIndex: rowIndex
    });
  }
});
exports.getLeadingControlColumn = getLeadingControlColumn;