"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertsSearchBar = AlertsSearchBar;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("./constants");
var _translations = require("./translations");
var _use_alert_data_view = require("../../hooks/use_alert_data_view");
var _use_rule_aad_fields = require("../../hooks/use_rule_aad_fields");
var _use_load_rule_types_query = require("../../hooks/use_load_rule_types_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SA_ALERTS = {
  type: 'alerts',
  fields: {}
};

// TODO Share buildEsQuery to be used between AlertsSearchBar and AlertsStateTable component https://github.com/elastic/kibana/issues/144615
// Also TODO: Replace all references to this component with the one from alerts-ui-shared
function AlertsSearchBar({
  appName,
  disableQueryLanguageSwitcher = false,
  featureIds,
  ruleTypeId,
  query,
  filters,
  onQueryChange,
  onQuerySubmit,
  onFiltersUpdated,
  rangeFrom,
  rangeTo,
  showFilterBar = false,
  showDatePicker = true,
  showSubmitButton = true,
  placeholder = _translations.SEARCH_BAR_PLACEHOLDER,
  submitOnBlur = false
}) {
  var _ruleType$ruleTypesSt;
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _public.useKibana)().services;
  const [queryLanguage, setQueryLanguage] = (0, _react.useState)('kuery');
  const {
    dataviews,
    loading
  } = (0, _use_alert_data_view.useAlertDataView)(featureIds !== null && featureIds !== void 0 ? featureIds : []);
  const {
    aadFields,
    loading: fieldsLoading
  } = (0, _use_rule_aad_fields.useRuleAADFields)(ruleTypeId);
  const indexPatterns = ruleTypeId && aadFields !== null && aadFields !== void 0 && aadFields.length ? [{
    title: ruleTypeId,
    fields: aadFields
  }] : dataviews;
  const ruleType = (0, _use_load_rule_types_query.useLoadRuleTypesQuery)({
    filteredRuleTypes: ruleTypeId !== undefined ? [ruleTypeId] : [],
    enabled: ruleTypeId !== undefined
  });
  const isSecurity = featureIds && featureIds.length === 1 && featureIds.includes(_ruleDataUtils.AlertConsumers.SIEM) || ruleType && ruleTypeId && ((_ruleType$ruleTypesSt = ruleType.ruleTypesState.data.get(ruleTypeId)) === null || _ruleType$ruleTypesSt === void 0 ? void 0 : _ruleType$ruleTypesSt.producer) === _ruleDataUtils.AlertConsumers.SIEM;
  const onSearchQuerySubmit = (0, _react.useCallback)(({
    dateRange,
    query: nextQuery
  }) => {
    var _nextQuery$language;
    onQuerySubmit({
      dateRange,
      query: typeof (nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.query) === 'string' ? nextQuery.query : undefined
    });
    setQueryLanguage((_nextQuery$language = nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.language) !== null && _nextQuery$language !== void 0 ? _nextQuery$language : 'kuery');
  }, [onQuerySubmit, setQueryLanguage]);
  const onSearchQueryChange = (0, _react.useCallback)(({
    dateRange,
    query: nextQuery
  }) => {
    var _nextQuery$language2;
    onQueryChange === null || onQueryChange === void 0 ? void 0 : onQueryChange({
      dateRange,
      query: typeof (nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.query) === 'string' ? nextQuery.query : undefined
    });
    setQueryLanguage((_nextQuery$language2 = nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.language) !== null && _nextQuery$language2 !== void 0 ? _nextQuery$language2 : 'kuery');
  }, [onQueryChange, setQueryLanguage]);
  const onRefresh = ({
    dateRange
  }) => {
    onQuerySubmit({
      dateRange
    });
  };
  return /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: appName,
    disableQueryLanguageSwitcher: disableQueryLanguageSwitcher
    // @ts-expect-error - DataView fields prop and SearchBar indexPatterns props are overly broad
    ,
    indexPatterns: loading || fieldsLoading ? _constants.NO_INDEX_PATTERNS : indexPatterns,
    placeholder: placeholder,
    query: {
      query: query !== null && query !== void 0 ? query : '',
      language: queryLanguage
    },
    filters: filters,
    dateRangeFrom: rangeFrom,
    dateRangeTo: rangeTo,
    displayStyle: "inPage",
    showFilterBar: showFilterBar,
    onQuerySubmit: onSearchQuerySubmit,
    onFiltersUpdated: onFiltersUpdated,
    onRefresh: onRefresh,
    showDatePicker: showDatePicker,
    showQueryInput: true,
    saveQueryMenuVisibility: "allowed_by_app_privilege",
    showSubmitButton: showSubmitButton,
    submitOnBlur: submitOnBlur,
    onQueryChange: onSearchQueryChange,
    suggestionsAbstraction: isSecurity ? undefined : SA_ALERTS
  });
}

// eslint-disable-next-line import/no-default-export