"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllAlertCounts = void 0;
var _react = _interopRequireDefault(require("react"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AllAlertCounts = ({
  count
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: _constants.ALL_ALERT_COLOR
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "data-test-subj": _constants.TOTAL_ALERT_COUNT_DATA_TEST_SUBJ
  }, (0, _numeral.default)(count).format(_constants.ALERT_COUNT_FORMAT))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _constants.ALERTS_LABEL));
};
exports.AllAlertCounts = AllAlertCounts;