"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryAlertProvidedActionVariables = exports.LegacyAlertProvidedActionVariables = exports.AlertProvidedActionVariables = void 0;
exports.transformActionVariables = transformActionVariables;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformProvidedActionVariables(actionVariables, omitMessageVariables) {
  if (!actionVariables) {
    return [];
  }
  const filteredActionVariables = omitMessageVariables ? omitMessageVariables === 'all' ? (0, _lodash.pick)(actionVariables, _types.REQUIRED_ACTION_VARIABLES) : (0, _lodash.pick)(actionVariables, [..._types.REQUIRED_ACTION_VARIABLES, ..._types.CONTEXT_ACTION_VARIABLES]) : actionVariables;
  const paramsVars = prefixKeys(filteredActionVariables.params, 'rule.params.');
  const contextVars = filteredActionVariables.context ? prefixKeys(filteredActionVariables.context, 'context.') : [];
  const stateVars = filteredActionVariables.state ? prefixKeys(filteredActionVariables.state, 'state.') : [];
  return contextVars.concat(paramsVars, stateVars);
}

// return a "flattened" list of action variables for an alertType
function transformActionVariables(actionVariables, summaryActionVariables, omitMessageVariables, isSummaryAction) {
  if (isSummaryAction) {
    const alwaysProvidedVars = getSummaryAlertActionVariables();
    const transformedActionVars = transformProvidedActionVariables(summaryActionVariables, omitMessageVariables);
    return alwaysProvidedVars.concat(transformedActionVars);
  }
  const alwaysProvidedVars = getAlwaysProvidedActionVariables();
  const transformedActionVars = transformProvidedActionVariables(actionVariables, omitMessageVariables);
  return alwaysProvidedVars.concat(transformedActionVars);
}
let AlertProvidedActionVariables;
exports.AlertProvidedActionVariables = AlertProvidedActionVariables;
(function (AlertProvidedActionVariables) {
  AlertProvidedActionVariables["ruleId"] = "rule.id";
  AlertProvidedActionVariables["ruleName"] = "rule.name";
  AlertProvidedActionVariables["ruleSpaceId"] = "rule.spaceId";
  AlertProvidedActionVariables["ruleTags"] = "rule.tags";
  AlertProvidedActionVariables["ruleType"] = "rule.type";
  AlertProvidedActionVariables["ruleUrl"] = "rule.url";
  AlertProvidedActionVariables["ruleParams"] = "rule.params";
  AlertProvidedActionVariables["date"] = "date";
  AlertProvidedActionVariables["alertId"] = "alert.id";
  AlertProvidedActionVariables["alertActionGroup"] = "alert.actionGroup";
  AlertProvidedActionVariables["alertActionGroupName"] = "alert.actionGroupName";
  AlertProvidedActionVariables["alertActionSubgroup"] = "alert.actionSubgroup";
  AlertProvidedActionVariables["alertFlapping"] = "alert.flapping";
  AlertProvidedActionVariables["kibanaBaseUrl"] = "kibanaBaseUrl";
})(AlertProvidedActionVariables || (exports.AlertProvidedActionVariables = AlertProvidedActionVariables = {}));
let LegacyAlertProvidedActionVariables;
exports.LegacyAlertProvidedActionVariables = LegacyAlertProvidedActionVariables;
(function (LegacyAlertProvidedActionVariables) {
  LegacyAlertProvidedActionVariables["alertId"] = "alertId";
  LegacyAlertProvidedActionVariables["alertName"] = "alertName";
  LegacyAlertProvidedActionVariables["alertInstanceId"] = "alertInstanceId";
  LegacyAlertProvidedActionVariables["alertActionGroup"] = "alertActionGroup";
  LegacyAlertProvidedActionVariables["alertActionGroupName"] = "alertActionGroupName";
  LegacyAlertProvidedActionVariables["alertActionSubgroup"] = "alertActionSubgroup";
  LegacyAlertProvidedActionVariables["tags"] = "tags";
  LegacyAlertProvidedActionVariables["spaceId"] = "spaceId";
  LegacyAlertProvidedActionVariables["params"] = "params";
})(LegacyAlertProvidedActionVariables || (exports.LegacyAlertProvidedActionVariables = LegacyAlertProvidedActionVariables = {}));
let SummaryAlertProvidedActionVariables;
exports.SummaryAlertProvidedActionVariables = SummaryAlertProvidedActionVariables;
(function (SummaryAlertProvidedActionVariables) {
  SummaryAlertProvidedActionVariables["ruleParams"] = "rule.params";
  SummaryAlertProvidedActionVariables["newAlertsCount"] = "alerts.new.count";
  SummaryAlertProvidedActionVariables["newAlertsData"] = "alerts.new.data";
  SummaryAlertProvidedActionVariables["ongoingAlertsCount"] = "alerts.ongoing.count";
  SummaryAlertProvidedActionVariables["ongoingAlertsData"] = "alerts.ongoing.data";
  SummaryAlertProvidedActionVariables["recoveredAlertsCount"] = "alerts.recovered.count";
  SummaryAlertProvidedActionVariables["recoveredAlertsData"] = "alerts.recovered.data";
  SummaryAlertProvidedActionVariables["allAlertsCount"] = "alerts.all.count";
  SummaryAlertProvidedActionVariables["allAlertsData"] = "alerts.all.data";
})(SummaryAlertProvidedActionVariables || (exports.SummaryAlertProvidedActionVariables = SummaryAlertProvidedActionVariables = {}));
const AlertProvidedActionVariableDescriptions = {
  [AlertProvidedActionVariables.ruleId]: {
    name: AlertProvidedActionVariables.ruleId,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.ruleIdLabel', {
      defaultMessage: 'The ID of the rule.'
    })
  },
  [AlertProvidedActionVariables.ruleName]: {
    name: AlertProvidedActionVariables.ruleName,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.ruleNameLabel', {
      defaultMessage: 'The name of the rule.'
    })
  },
  [AlertProvidedActionVariables.ruleSpaceId]: {
    name: AlertProvidedActionVariables.ruleSpaceId,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.ruleSpaceIdLabel', {
      defaultMessage: 'The space ID of the rule.'
    })
  },
  [AlertProvidedActionVariables.ruleTags]: {
    name: AlertProvidedActionVariables.ruleTags,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.ruleTagsLabel', {
      defaultMessage: 'The tags of the rule.'
    })
  },
  [AlertProvidedActionVariables.ruleType]: {
    name: AlertProvidedActionVariables.ruleType,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.ruleTypeLabel', {
      defaultMessage: 'The type of rule.'
    })
  },
  [AlertProvidedActionVariables.ruleUrl]: {
    name: AlertProvidedActionVariables.ruleUrl,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.ruleUrlLabel', {
      defaultMessage: 'The URL to the rule that generated the alert. This will be an empty string if the server.publicBaseUrl is not configured.'
    }),
    usesPublicBaseUrl: true
  },
  [AlertProvidedActionVariables.date]: {
    name: AlertProvidedActionVariables.date,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.dateLabel', {
      defaultMessage: 'The date the rule scheduled the action.'
    })
  },
  [AlertProvidedActionVariables.kibanaBaseUrl]: {
    name: AlertProvidedActionVariables.kibanaBaseUrl,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.kibanaBaseUrlLabel', {
      defaultMessage: 'The configured server.publicBaseUrl value or empty string if not configured.'
    })
  }
};
function prefixKeys(actionVariables, prefix) {
  return actionVariables.map(actionVariable => {
    return {
      ...actionVariable,
      name: `${prefix}${actionVariable.name}`
    };
  });
}

// this list should be the same as in:
//   x-pack/plugins/alerting/server/task_runner/transform_action_params.ts
function getAlwaysProvidedActionVariables() {
  const result = [];
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleId]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleName]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleSpaceId]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleTags]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleType]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleUrl]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.date]);
  result.push({
    name: AlertProvidedActionVariables.alertId,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.alertIdLabel', {
      defaultMessage: 'The ID of the alert that scheduled actions for the rule.'
    })
  });
  result.push({
    name: AlertProvidedActionVariables.alertActionGroup,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.alertActionGroupLabel', {
      defaultMessage: 'The action group of the alert that scheduled actions for the rule.'
    })
  });
  result.push({
    name: AlertProvidedActionVariables.alertActionSubgroup,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.alertActionSubgroupLabel', {
      defaultMessage: 'The action subgroup of the alert that scheduled actions for the rule.'
    })
  });
  result.push({
    name: AlertProvidedActionVariables.alertActionGroupName,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.alertActionGroupNameLabel', {
      defaultMessage: 'The human readable name of the action group of the alert that scheduled actions for the rule.'
    })
  });
  result.push({
    name: AlertProvidedActionVariables.alertFlapping,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.alertFlappingLabel', {
      defaultMessage: 'A flag on the alert that indicates whether the alert status is changing repeatedly.'
    })
  });
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.kibanaBaseUrl]);
  result.push({
    name: LegacyAlertProvidedActionVariables.alertId,
    deprecated: true,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.legacyAlertIdLabel', {
      defaultMessage: 'This has been deprecated in favor of {variable}.',
      values: {
        variable: AlertProvidedActionVariables.ruleId
      }
    })
  });
  result.push({
    name: LegacyAlertProvidedActionVariables.alertName,
    deprecated: true,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.legacyAlertNameLabel', {
      defaultMessage: 'This has been deprecated in favor of {variable}.',
      values: {
        variable: AlertProvidedActionVariables.ruleName
      }
    })
  });
  result.push({
    name: LegacyAlertProvidedActionVariables.alertInstanceId,
    deprecated: true,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.legacyAlertInstanceIdLabel', {
      defaultMessage: 'This has been deprecated in favor of {variable}.',
      values: {
        variable: AlertProvidedActionVariables.alertId
      }
    })
  });
  result.push({
    name: LegacyAlertProvidedActionVariables.alertActionGroup,
    deprecated: true,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.legacyAlertActionGroupLabel', {
      defaultMessage: 'This has been deprecated in favor of {variable}.',
      values: {
        variable: AlertProvidedActionVariables.alertActionGroup
      }
    })
  });
  result.push({
    name: LegacyAlertProvidedActionVariables.alertActionGroupName,
    deprecated: true,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.legacyAlertActionGroupNameLabel', {
      defaultMessage: 'This has been deprecated in favor of {variable}.',
      values: {
        variable: AlertProvidedActionVariables.alertActionGroupName
      }
    })
  });
  result.push({
    name: LegacyAlertProvidedActionVariables.alertActionSubgroup,
    deprecated: true,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.legacyAlertActionSubGroupLabel', {
      defaultMessage: 'This has been deprecated in favor of {variable}.',
      values: {
        variable: AlertProvidedActionVariables.alertActionSubgroup
      }
    })
  });
  result.push({
    name: LegacyAlertProvidedActionVariables.spaceId,
    deprecated: true,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.legacySpaceIdLabel', {
      defaultMessage: 'This has been deprecated in favor of {variable}.',
      values: {
        variable: AlertProvidedActionVariables.ruleSpaceId
      }
    })
  });
  result.push({
    name: LegacyAlertProvidedActionVariables.tags,
    deprecated: true,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.legacyTagsLabel', {
      defaultMessage: 'This has been deprecated in favor of {variable}.',
      values: {
        variable: AlertProvidedActionVariables.ruleTags
      }
    })
  });
  result.push({
    name: LegacyAlertProvidedActionVariables.params,
    deprecated: true,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.legacyParamsLabel', {
      defaultMessage: 'This has been deprecated in favor of {variable}.',
      values: {
        variable: AlertProvidedActionVariables.ruleParams
      }
    })
  });
  return result;
}
function getSummaryAlertActionVariables() {
  const result = [];
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.kibanaBaseUrl]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.date]);
  result.push({
    name: SummaryAlertProvidedActionVariables.ruleParams,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.ruleParamsLabel', {
      defaultMessage: 'The params of the rule.'
    })
  });
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleId]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleName]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleType]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleUrl]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleTags]);
  result.push(AlertProvidedActionVariableDescriptions[AlertProvidedActionVariables.ruleSpaceId]);
  result.push({
    name: SummaryAlertProvidedActionVariables.newAlertsCount,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.newAlertsCountLabel', {
      defaultMessage: 'The count of new alerts.'
    })
  });
  result.push({
    name: SummaryAlertProvidedActionVariables.newAlertsData,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.newAlertsDataLabel', {
      defaultMessage: 'An array of objects for new alerts.'
    })
  });
  result.push({
    name: SummaryAlertProvidedActionVariables.ongoingAlertsCount,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.ongoingAlertsCountLabel', {
      defaultMessage: 'The count of ongoing alerts.'
    })
  });
  result.push({
    name: SummaryAlertProvidedActionVariables.ongoingAlertsData,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.ongoingAlertsDataLabel', {
      defaultMessage: 'An array of objects for ongoing alerts.'
    })
  });
  result.push({
    name: SummaryAlertProvidedActionVariables.recoveredAlertsCount,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.recoveredAlertsCountLabel', {
      defaultMessage: 'The count of recovered alerts.'
    })
  });
  result.push({
    name: SummaryAlertProvidedActionVariables.recoveredAlertsData,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.recoveredAlertsDataLabel', {
      defaultMessage: 'An array of objects for recovered alerts.'
    })
  });
  result.push({
    name: SummaryAlertProvidedActionVariables.allAlertsCount,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.allAlertsCountLabel', {
      defaultMessage: 'The count of all alerts.'
    })
  });
  result.push({
    name: SummaryAlertProvidedActionVariables.allAlertsData,
    description: _i18n.i18n.translate('xpack.triggersActionsUI.actionVariables.allAlertsDataLabel', {
      defaultMessage: 'An array of objects for all alerts.'
    })
  });
  return result;
}