"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateApiKeyModalConfirmation = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../common/lib/kibana");
var _use_bulk_edit_response = require("../hooks/use_bulk_edit_response");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpdateApiKeyModalConfirmation = ({
  onCancel,
  idsToUpdate,
  rulesToUpdate,
  idsToUpdateFilter,
  numberOfSelectedRules = 0,
  apiUpdateApiKeyCall,
  setIsLoadingState,
  onUpdated,
  onSearchPopulate
}) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [updateModalFlyoutVisible, setUpdateModalVisibility] = (0, _react.useState)(false);
  const {
    showToast
  } = (0, _use_bulk_edit_response.useBulkEditResponse)({
    onSearchPopulate
  });
  const computedIdsToUpdate = (0, _react.useMemo)(() => {
    if (idsToUpdate !== null && idsToUpdate !== void 0 && idsToUpdate.length) {
      return idsToUpdate;
    }
    if (rulesToUpdate !== null && rulesToUpdate !== void 0 && rulesToUpdate.length) {
      return rulesToUpdate.map(rule => rule.id);
    }
    return [];
  }, [idsToUpdate, rulesToUpdate]);
  (0, _react.useEffect)(() => {
    if (typeof idsToUpdateFilter !== 'undefined') {
      setUpdateModalVisibility(true);
    } else {
      setUpdateModalVisibility(computedIdsToUpdate.length > 0);
    }
  }, [computedIdsToUpdate, idsToUpdateFilter]);
  const numberOfIdsToUpdate = (0, _react.useMemo)(() => {
    if (typeof idsToUpdateFilter !== 'undefined') {
      return numberOfSelectedRules;
    }
    return computedIdsToUpdate.length;
  }, [idsToUpdateFilter, numberOfSelectedRules, computedIdsToUpdate]);
  return updateModalFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "primary",
    "data-test-subj": "updateApiKeyIdsConfirmation",
    title: _i18n.i18n.translate('xpack.triggersActionsUI.updateApiKeyConfirmModal.title', {
      defaultMessage: 'Update API key'
    }),
    onCancel: () => {
      setUpdateModalVisibility(false);
      onCancel();
    },
    onConfirm: async () => {
      setUpdateModalVisibility(false);
      setIsLoadingState(true);
      try {
        const response = await apiUpdateApiKeyCall({
          ids: computedIdsToUpdate,
          filter: idsToUpdateFilter,
          http
        });
        showToast(response, 'apiKey');
      } catch (e) {
        toasts.addError(e, {
          title: _i18n.i18n.translate('xpack.triggersActionsUI.updateApiKeyConfirmModal.failureMessage', {
            defaultMessage: 'Failed to update the API {idsToUpdate, plural, one {key} other {keys}}',
            values: {
              idsToUpdate: numberOfIdsToUpdate
            }
          })
        });
      }
      setIsLoadingState(false);
      onUpdated();
    },
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.updateApiKeyConfirmModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.updateApiKeyConfirmModal.confirmButton', {
      defaultMessage: 'Update'
    })
  }, _i18n.i18n.translate('xpack.triggersActionsUI.updateApiKeyConfirmModal.description', {
    defaultMessage: 'You will not be able to recover the old API {idsToUpdate, plural, one {key} other {keys}}',
    values: {
      idsToUpdate: numberOfIdsToUpdate
    }
  })) : null;
};
exports.UpdateApiKeyModalConfirmation = UpdateApiKeyModalConfirmation;