"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsRange = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesSettingsRange = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    label,
    labelPopoverText,
    min,
    max,
    value,
    disabled,
    onChange,
    ...rest
  } = props;
  const renderLabel = () => {
    return /*#__PURE__*/_react.default.createElement("div", null, label, "\xA0", labelPopoverText && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      size: "s",
      type: "questionInCircle",
      content: labelPopoverText
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: renderLabel()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, (0, _extends2.default)({
    min: min,
    max: max,
    step: 1,
    value: value,
    disabled: disabled,
    onChange: onChange,
    showLabels: true,
    showValue: true
  }, rest)));
});
exports.RulesSettingsRange = RulesSettingsRange;