"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _api_create_query_schema = require("@kbn/ml-data-view-utils/schemas/api_create_query_schema");
var _common = require("../../../../common/api_schemas/common");
var _transforms = require("../../../../common/api_schemas/transforms");
var _constants = require("../../../../common/constants");
var _route_handler_factory = require("./route_handler_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute(routeDependencies) {
  const {
    router,
    license
  } = routeDependencies;

  /**
   * @apiGroup Transforms
   *
   * @api {put} /internal/transform/transforms/:transformId Put transform
   * @apiName PutTransform
   * @apiDescription Creates a transform
   *
   * @apiSchema (params) transformIdParamSchema
   * @apiSchema (query) transformIdParamSchema
   * @apiSchema (body) putTransformsRequestSchema
   */
  router.versioned.put({
    path: (0, _constants.addInternalBasePath)('transforms/{transformId}'),
    access: 'internal'
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: _common.transformIdParamSchema,
        query: _api_create_query_schema.dataViewCreateQuerySchema,
        body: _transforms.putTransformsRequestSchema
      }
    }
  }, license.guardApiRoute((0, _route_handler_factory.routeHandlerFactory)(routeDependencies)));
}