"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _constants = require("../../../../common/constants");
var _common = require("../../../../common/api_schemas/common");
var _field_histograms = require("../../../../common/api_schemas/field_histograms");
var _route_handler = require("./route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute({
  router,
  license
}) {
  router.versioned.post({
    path: (0, _constants.addInternalBasePath)('field_histograms/{dataViewTitle}'),
    access: 'internal'
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: _common.dataViewTitleSchema,
        body: _field_histograms.fieldHistogramsRequestSchema
      }
    }
  }, license.guardApiRoute(_route_handler.routeHandler));
}