"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _managed_transforms_utils = require("../../../../common/managed_transforms_utils");
var _managed_transforms_callout = require("../managed_transforms_callout/managed_transforms_callout");
var _edit_transform_api_error_callout = require("./edit_transform_api_error_callout");
var _edit_transform_flyout_callout = require("./edit_transform_flyout_callout");
var _edit_transform_flyout_form = require("./edit_transform_flyout_form");
var _use_edit_transform_flyout = require("./use_edit_transform_flyout");
var _edit_transform_update_button = require("./edit_transform_update_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditTransformFlyout = ({
  closeFlyout,
  config,
  dataViewId,
  isFlyoutVisible
}) => config && isFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_use_edit_transform_flyout.EditTransformFlyoutProvider, {
  config: config,
  dataViewId: dataViewId
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
  onClose: closeFlyout,
  hideCloseButton: true,
  "aria-labelledby": "transformEditFlyoutTitle",
  "data-test-subj": "transformEditFlyout"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "m"
}, /*#__PURE__*/_react.default.createElement("h2", {
  id: "transformEditFlyoutTitle"
}, _i18n.i18n.translate('xpack.transform.transformList.editFlyoutTitle', {
  defaultMessage: 'Edit {transformId}',
  values: {
    transformId: config.id
  }
})))), (0, _managed_transforms_utils.isManagedTransform)({
  config
}) ? /*#__PURE__*/_react.default.createElement(_managed_transforms_callout.ManagedTransformsWarningCallout, {
  count: 1,
  action: _i18n.i18n.translate('xpack.transform.transformList.editManagedTransformsDescription', {
    defaultMessage: 'editing'
  })
}) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
  banner: /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_callout.EditTransformFlyoutCallout, null)
}, /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form.EditTransformFlyoutForm, null), /*#__PURE__*/_react.default.createElement(_edit_transform_api_error_callout.EditTransformApiErrorCallout, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconType: "cross",
  onClick: closeFlyout,
  flush: "left"
}, _i18n.i18n.translate('xpack.transform.transformList.editFlyoutCancelButtonText', {
  defaultMessage: 'Cancel'
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_edit_transform_update_button.EditTransformUpdateButton, {
  closeFlyout: closeFlyout
})))))) : null;
exports.EditTransformFlyout = EditTransformFlyout;