"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformApiErrorCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_edit_transform_flyout = require("./use_edit_transform_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditTransformApiErrorCallout = () => {
  const apiErrorMessage = (0, _use_edit_transform_flyout.useEditTransformFlyout)('apiErrorMessage');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, apiErrorMessage !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.transform.transformList.editTransformGenericErrorMessage', {
      defaultMessage: 'An error occurred calling the API endpoint to update transforms.'
    }),
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, apiErrorMessage))));
};
exports.EditTransformApiErrorCallout = EditTransformApiErrorCallout;