"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefreshTransformList = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRefreshTransformList = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return () => {
    queryClient.invalidateQueries([_constants.TRANSFORM_REACT_QUERY_KEYS.GET_TRANSFORM_NODES]);
    queryClient.invalidateQueries([_constants.TRANSFORM_REACT_QUERY_KEYS.GET_TRANSFORMS]);
    queryClient.invalidateQueries([_constants.TRANSFORM_REACT_QUERY_KEYS.GET_TRANSFORMS_STATS]);
    queryClient.invalidateQueries([_constants.TRANSFORM_REACT_QUERY_KEYS.GET_TRANSFORM_AUDIT_MESSAGES]);
  };
};
exports.useRefreshTransformList = useRefreshTransformList;