"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToastNotificationText = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_SIMPLE_MESSAGE_LENGTH = 140;
const ToastNotificationText = ({
  text,
  previewTextLength,
  inline = false,
  forceModal = false
}) => {
  const {
    overlays,
    theme,
    i18n: i18nStart
  } = (0, _app_dependencies.useAppDependencies)();
  if (!forceModal && typeof text === 'string' && text.length <= MAX_SIMPLE_MESSAGE_LENGTH) {
    return text;
  }
  if (!forceModal && typeof text === 'object' && text !== null && typeof text.message === 'string' && text.message.length <= MAX_SIMPLE_MESSAGE_LENGTH) {
    return text.message;
  }
  const unformattedText = typeof text === 'object' && text !== null && text.message ? text.message : text;
  const formattedText = typeof unformattedText === 'object' ? JSON.stringify(text, null, 2) : unformattedText;
  const textLength = previewTextLength !== null && previewTextLength !== void 0 ? previewTextLength : 140;
  const previewText = `${formattedText.substring(0, textLength)}${formattedText.length > textLength ? ' ...' : ''}`;
  const openModal = () => {
    const modal = overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: () => modal.close()
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.transform.toastText.modalTitle', {
      defaultMessage: 'Error details'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      fontSize: "m",
      paddingSize: "s",
      isCopyable: true
    }, formattedText)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => modal.close()
    }, _i18n.i18n.translate('xpack.transform.toastText.closeModalButtonText', {
      defaultMessage: 'Close'
    })))), {
      theme,
      i18n: i18nStart
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !inline && /*#__PURE__*/_react.default.createElement("pre", null, previewText), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: openModal,
    css: inline ? {
      blockSize: 0
    } : {},
    size: inline ? 's' : undefined
  }, _i18n.i18n.translate('xpack.transform.toastText.openModalButtonText', {
    defaultMessage: 'View details'
  })));
};
exports.ToastNotificationText = ToastNotificationText;