"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineEventsAllSchema = void 0;
var _zod = require("zod");
var _language = require("../model/language");
var _runtime_mappings = require("../model/runtime_mappings");
var _sort = require("../model/sort");
var _timeline_events_queries = require("../model/timeline_events_queries");
var _request_paginated = require("./request_paginated");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extendedSortItem = _sort.sortItem.extend({
  esTypes: _zod.z.array(_zod.z.string())
});
const sort = _zod.z.array(extendedSortItem);
const timelineEventsAllSchema = _request_paginated.requestPaginated.extend({
  authFilter: _zod.z.object({}).optional(),
  excludeEcsData: _zod.z.boolean().optional(),
  fieldRequested: _zod.z.array(_zod.z.string()),
  sort,
  filterQuery: _zod.z.any(),
  fields: _zod.z.array(_zod.z.union([_zod.z.string(), _zod.z.object({
    field: _zod.z.string(),
    include_unmapped: _zod.z.boolean()
  })])),
  runtimeMappings: _runtime_mappings.runtimeMappings,
  language: _language.language,
  factoryQueryType: _zod.z.literal(_timeline_events_queries.TimelineEventsQueries.all)
});
exports.timelineEventsAllSchema = timelineEventsAllSchema;