"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToTimelineContextMenu = exports.AddToTimelineCellAction = exports.AddToTimelineButtonIcon = exports.AddToTimelineButtonEmpty = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _data_provider = require("../utils/data_provider");
var _field_value = require("../../indicators/utils/field_value");
var _use_kibana = require("../../../hooks/use_kibana");
var _styles = require("./styles");
var _use_add_to_timeline = require("../hooks/use_add_to_timeline");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON_TYPE = 'timeline';
/**
 * Add to timeline feature, leverages the built-in functionality retrieves from the timeLineService (see ThreatIntelligenceSecuritySolutionContext in x-pack/plugins/threat_intelligence/public/types.ts)
 * Clicking on the button will add a key-value pair to an Untitled timeline.
 *
 * This component is renders an {@link EuiButtonIcon}.
 *
 * @returns add to timeline button or an empty component
 */
const AddToTimelineButtonIcon = ({
  data,
  field,
  'data-test-subj': dataTestSubj
}) => {
  const addToTimelineButton = (0, _use_kibana.useKibana)().services.timelines.getHoverActions().getAddToTimelineButton;
  const {
    addToTimelineProps
  } = (0, _use_add_to_timeline.useAddToTimeline)({
    indicator: data,
    field
  });
  if (!addToTimelineProps) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSubj
  }, addToTimelineButton(addToTimelineProps)));
};

/**
 * Add to timeline feature, leverages the built-in functionality retrieves from the timeLineService (see ThreatIntelligenceSecuritySolutionContext in x-pack/plugins/threat_intelligence/public/types.ts)
 * Clicking on the button will add a key-value pair to an Untitled timeline.
 *
 * This component is renders an {@link EuiButtonEmpty}.
 *
 * @returns add to timeline button or an empty component
 */
exports.AddToTimelineButtonIcon = AddToTimelineButtonIcon;
const AddToTimelineButtonEmpty = ({
  data,
  field,
  'data-test-subj': dataTestSubj
}) => {
  const styles = (0, _styles.useStyles)();
  const buttonRef = (0, _react.useRef)(null);
  const addToTimelineButton = (0, _use_kibana.useKibana)().services.timelines.getHoverActions().getAddToTimelineButton;
  const {
    key,
    value
  } = typeof data === 'string' ? {
    key: field,
    value: data
  } : (0, _field_value.getIndicatorFieldAndValue)(data, field);
  if (!(0, _field_value.fieldAndValueValid)(key, value)) {
    return null;
  }
  const dataProvider = [(0, _data_provider.generateDataProvider)(key, value)];
  const addToTimelineProps = {
    dataProvider,
    field: key,
    ownFocus: false
  };

  // Use case is for the barchart legend (for example).
  // We can't use the addToTimelineButton directly because the UI doesn't work in a EuiContextMenu.
  // We hide it and use the defaultFocusedButtonRef props to programmatically click it.
  addToTimelineProps.defaultFocusedButtonRef = buttonRef;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.displayNone
  }, addToTimelineButton(addToTimelineProps)), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _translations.TITLE,
    iconType: ICON_TYPE,
    iconSize: "s",
    color: "primary",
    onClick: () => {
      var _buttonRef$current;
      return (_buttonRef$current = buttonRef.current) === null || _buttonRef$current === void 0 ? void 0 : _buttonRef$current.click();
    },
    "data-test-subj": dataTestSubj
  }, _translations.TITLE)));
};

/**
 * Add to timeline feature, leverages the built-in functionality retrieves from the timeLineService (see ThreatIntelligenceSecuritySolutionContext in x-pack/plugins/threat_intelligence/public/types.ts)
 * Clicking on the button will add a key-value pair to an Untitled timeline.
 *
 * This component is to be used in an EuiContextMenu.
 *
 * @returns add to timeline {@link EuiContextMenuItem} for a context menu
 */
exports.AddToTimelineButtonEmpty = AddToTimelineButtonEmpty;
const AddToTimelineContextMenu = ({
  data,
  field,
  'data-test-subj': dataTestSubj
}) => {
  const styles = (0, _styles.useStyles)();
  const contextMenuRef = (0, _react.useRef)(null);
  const addToTimelineButton = (0, _use_kibana.useKibana)().services.timelines.getHoverActions().getAddToTimelineButton;
  const {
    key,
    value
  } = typeof data === 'string' ? {
    key: field,
    value: data
  } : (0, _field_value.getIndicatorFieldAndValue)(data, field);
  if (!(0, _field_value.fieldAndValueValid)(key, value)) {
    return null;
  }
  const dataProvider = [(0, _data_provider.generateDataProvider)(key, value)];
  const addToTimelineProps = {
    dataProvider,
    field: key,
    ownFocus: false
  };

  // Use case is for the barchart legend (for example).
  // We can't use the addToTimelineButton directly because the UI doesn't work in a EuiContextMenu.
  // We hide it and use the defaultFocusedButtonRef props to programmatically click it.
  addToTimelineProps.defaultFocusedButtonRef = contextMenuRef;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.displayNone
  }, addToTimelineButton(addToTimelineProps)), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "addToTimeline",
    icon: ICON_TYPE,
    size: "s",
    onClick: () => {
      var _contextMenuRef$curre;
      return (_contextMenuRef$curre = contextMenuRef.current) === null || _contextMenuRef$curre === void 0 ? void 0 : _contextMenuRef$curre.click();
    },
    "data-test-subj": dataTestSubj
  }, _translations.TITLE));
};

/**
 * Add to timeline feature, leverages the built-in functionality retrieves from the timeLineService (see ThreatIntelligenceSecuritySolutionContext in x-pack/plugins/threat_intelligence/public/types.ts)
 * Clicking on the button will add a key-value pair to an Untitled timeline.
 *
 * This component is to be used as a cellAction in an {@link EuiDataGrid}.
 *
 * @returns add to timeline button or an empty component
 */
exports.AddToTimelineContextMenu = AddToTimelineContextMenu;
const AddToTimelineCellAction = ({
  data,
  field,
  Component,
  'data-test-subj': dataTestSubj
}) => {
  const addToTimelineButton = (0, _use_kibana.useKibana)().services.timelines.getHoverActions().getAddToTimelineButton;
  const {
    addToTimelineProps
  } = (0, _use_add_to_timeline.useAddToTimeline)({
    indicator: data,
    field
  });
  if (!addToTimelineProps) {
    return null;
  }
  addToTimelineProps.Component = Component;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSubj
  }, addToTimelineButton(addToTimelineProps)));
};
exports.AddToTimelineCellAction = AddToTimelineCellAction;