(window.textBasedLanguages_bundle_jsonpfunction=window.textBasedLanguages_bundle_jsonpfunction||[]).push([[2],{50:function(e,n,t){"use strict";t.r(n),t.d(n,"initialSection",(function(){return o})),t.d(n,"sourceCommands",(function(){return r})),t.d(n,"processingCommands",(function(){return d})),t.d(n,"functions",(function(){return l})),t.d(n,"aggregationFunctions",(function(){return u})),t.d(n,"operators",(function(){return c})),t(0);var a=t(15),s=t(3),i=t(1);const o=Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.markdown",{defaultMessage:"## ES|QL\n\nAn ES|QL (Elasticsearch query language) query consists of a series of commands, separated by pipe characters: `|`. Each query starts with a **source command**, which produces a table, typically with data from Elasticsearch. \n\nA source command can be followed by one or more **processing commands**. Processing commands can change the output table of the previous command by adding, removing, and changing rows and columns.\n\n```\nsource-command\n| processing-command1\n| processing-command2\n```\n\nThe result of a query is the table produced by the final processing command.                                  \n                                      "})}),r={label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.sourceCommands",{defaultMessage:"Source commands"}),description:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.commandsDescription",{defaultMessage:"A source command produces a table, typically with data from Elasticsearch. ES|QL supports the following source commands."}),items:[{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.from",{defaultMessage:"FROM"}),description:Object(i.jsx)(s.Markdown,{openLinksInNewTab:!0,markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.from.markdown",{defaultMessage:"### FROM\nThe `FROM` source command returns a table with up to 10,000 documents from a data stream, index, or alias. Each row in the resulting table represents a document. Each column corresponds to a field, and can be accessed by the name of that field.\n\n```\nFROM employees\n```\n\nYou can use [date math](https://www.elastic.co/guide/en/elasticsearch/reference/current/api-conventions.html#api-date-math-index-names) to refer to indices, aliases and data streams. This can be useful for time series data.\n\nUse comma-separated lists or wildcards to query multiple data streams, indices, or aliases:\n\n```\nFROM employees-00001,employees-*\n```\n\n#### Metadata\n\nES|QL can access the following metadata fields:\n\n* `_index`: the index to which the document belongs. The field is of the type `keyword`.\n* `_id`: the source document's ID. The field is of the type `keyword`.\n* `_version`: the source document's version. The field is of the type `long`.\n\nUse the `METADATA` directive to enable metadata fields:\n\n```\nFROM index [METADATA _index, _id]\n```\n\nMetadata fields are only available if the source of the data is an index. Consequently, `FROM` is the only source commands that supports the `METADATA` directive.\n\nOnce enabled, the fields are then available to subsequent processing commands, just like the other index fields:\n\n```\nFROM ul_logs, apps [METADATA _index, _version]\n| WHERE id IN (13, 14) AND _version == 1\n| EVAL key = CONCAT(_index, \"_\", TO_STR(id))\n| SORT id, _index\n| KEEP id, _index, _version, key\n```\n\nAlso, similar to the index fields, once an aggregation is performed, a metadata field will no longer be accessible to subsequent commands, unless used as grouping field:\n\n```\nFROM employees [METADATA _index, _id]\n| STATS max = MAX(emp_no) BY _index\n```\n            ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.row",{defaultMessage:"ROW"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.row.markdown",{defaultMessage:'### ROW\nThe `ROW` source command produces a row with one or more columns with values that you specify. This can be useful for testing.\n              \n```\nROW a = 1, b = "two", c = null\n```\n\nUse square brackets to create multi-value columns:\n\n```\nROW a = [2, 1]\n```\n\nROW supports the use of functions:\n\n```\nROW a = ROUND(1.23, 0)\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.show",{defaultMessage:"SHOW"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.show.markdown",{defaultMessage:"### SHOW\nThe `SHOW <item>` source command returns information about the deployment and its capabilities:\n\n* Use `SHOW INFO` to return the deployment's version, build date and hash.\n* Use `SHOW FUNCTIONS` to return a list of all supported functions and a synopsis of each function.\n            ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})}]},d={label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.processingCommands",{defaultMessage:"Processing commands"}),description:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.processingCommandsDescription",{defaultMessage:"Processing commands change an input table by adding, removing, or changing rows and columns. ES|QL supports the following processing commands."}),items:[{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.dissect",{defaultMessage:"DISSECT"}),description:Object(i.jsx)(s.Markdown,{openLinksInNewTab:!0,markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.dissect.markdown",{defaultMessage:'### DISSECT\n`DISSECT` enables you to extract structured data out of a string. `DISSECT` matches the string against a delimiter-based pattern, and extracts the specified keys as columns.\n\nRefer to the [dissect processor documentation](https://www.elastic.co/guide/en/elasticsearch/reference/current/dissect-processor.html) for the syntax of dissect patterns.\n\n```\nROW a = "1953-01-23T12:15:00Z - some text - 127.0.0.1"\n| DISSECT a "%\\{Y\\}-%\\{M\\}-%\\{D\\}T%\\{h\\}:%\\{m\\}:%\\{s\\}Z - %\\{msg\\} - %\\{ip\\}"\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.drop",{defaultMessage:"DROP"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.drop.markdown",{defaultMessage:"### DROP\nUse `DROP` to remove columns from a table:\n              \n```\nFROM employees\n| DROP height\n```\n\nRather than specify each column by name, you can use wildcards to drop all columns with a name that matches a pattern:\n\n```\nFROM employees\n| DROP height*\n```\n            ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.enrich",{defaultMessage:"ENRICH"}),description:Object(i.jsx)(s.Markdown,{openLinksInNewTab:!0,markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.enrich.markdown",{defaultMessage:'### ENRICH\nYou can use `ENRICH` to add data from your existing indices to incoming records. It’s similar to [ingest enrich](https://www.elastic.co/guide/en/elasticsearch/reference/current/ingest-enriching-data.html), but it works at query time.\n\n```\nROW language_code = "1"\n| ENRICH languages_policy\n```\n\n`ENRICH` requires an [enrich policy](https://www.elastic.co/guide/en/elasticsearch/reference/current/ingest-enriching-data.html#enrich-policy) to be executed. The enrich policy defines a match field (a key field) and a set of enrich fields.\n\n`ENRICH` will look for records in the [enrich index](https://www.elastic.co/guide/en/elasticsearch/reference/current/ingest-enriching-data.html#enrich-index) based on the match field value. The matching key in the input dataset can be defined using `ON <field-name>`; if it’s not specified, the match will be performed on a field with the same name as the match field defined in the enrich policy.\n\n```\nROW a = "1"\n| ENRICH languages_policy ON a\n```\n\nYou can specify which attributes (between those defined as enrich fields in the policy) have to be added to the result, using `WITH <field1>, <field2>...` syntax.\n\n```\nROW a = "1"\n| ENRICH languages_policy ON a WITH language_name\n```\n\nAttributes can also be renamed using `WITH new_name=<field1>`\n\n```\nROW a = "1"\n| ENRICH languages_policy ON a WITH name = language_name\n```\n\nBy default (if no `WITH` is defined), `ENRICH` will add all the enrich fields defined in the enrich policy to the result.\n\nIn case of name collisions, the newly created fields will override the existing fields.\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.eval",{defaultMessage:"EVAL"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.eval.markdown",{defaultMessage:"### EVAL\n`EVAL` enables you to add new columns:\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| EVAL height_feet = height * 3.281, height_cm = height * 100\n```\n\nIf the specified column already exists, the existing column will be dropped, and the new column will be appended to the table:\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| EVAL height = height * 3.281\n```\n\n#### Functions\n`EVAL` supports various functions for calculating values. Refer to Functions for more information.\n            ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.grok",{defaultMessage:"GROK"}),description:Object(i.jsx)(s.Markdown,{openLinksInNewTab:!0,markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.grok.markdown",{defaultMessage:'### GROK\n`GROK` enables you to extract structured data out of a string. `GROK` matches the string against patterns, based on regular expressions, and extracts the specified patterns as columns.\n\nRefer to the [grok processor documentation](https://www.elastic.co/guide/en/elasticsearch/reference/current/grok-processor.html) for the syntax of grok patterns.\n\n```\nROW a = "12 15.5 15.6 true"\n| GROK a "%\\{NUMBER:b:int\\} %\\{NUMBER:c:float\\} %\\{NUMBER:d:double\\} %\\{WORD:e:boolean\\}"\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.keep",{defaultMessage:"KEEP"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.keep.markdown",{defaultMessage:"### KEEP\nThe `KEEP` command enables you to specify what columns are returned and the order in which they are returned.\n\nTo limit the columns that are returned, use a comma-separated list of column names. The columns are returned in the specified order:\n              \n```\nFROM employees\n| KEEP first_name, last_name, height\n```\n\nRather than specify each column by name, you can use wildcards to return all columns with a name that matches a pattern:\n\n```\nFROM employees\n| KEEP h*\n```\n\nThe asterisk wildcard (`*`) by itself translates to all columns that do not match the other arguments. This query will first return all columns with a name that starts with an h, followed by all other columns:\n\n```\nFROM employees\n| KEEP h*, *\n```\n            ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.limit",{defaultMessage:"LIMIT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.limit.markdown",{defaultMessage:"### LIMIT\nThe `LIMIT` processing command enables you to limit the number of rows:\n              \n```\nFROM employees\n| LIMIT 5\n```\n            ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvExpand",{defaultMessage:"MV_EXPAND"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvExpand.markdown",{defaultMessage:'### MV_EXPAND\nThe `MV_EXPAND` processing command expands multivalued fields into one row per value, duplicating other fields:              \n```\nROW a=[1,2,3], b="b", j=["a","b"]\n| MV_EXPAND a\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.rename",{defaultMessage:"RENAME"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.rename.markdown",{defaultMessage:"### RENAME\nUse `RENAME` to rename a column using the following syntax:\n\n```\nRENAME <old-name> AS <new-name>\n```\n\nFor example:\n\n```\nFROM employees\n| KEEP first_name, last_name, still_hired\n| RENAME still_hired AS employed\n```\n\nIf a column with the new name already exists, it will be replaced by the new column.\n\nMultiple columns can be renamed with a single `RENAME` command:\n\n```\nFROM employees\n| KEEP first_name, last_name\n| RENAME first_name AS fn, last_name AS ln\n```\n            ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.sort",{defaultMessage:"SORT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.sort.markdown",{defaultMessage:"### SORT\nUse the `SORT` command to sort rows on one or more fields:\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| SORT height\n```\n\nThe default sort order is ascending. Set an explicit sort order using `ASC` or `DESC`:\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| SORT height DESC\n```\n\nIf two rows have the same sort key, the original order will be preserved. You can provide additional sort expressions to act as tie breakers:\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| SORT height DESC, first_name ASC\n```\n\n#### `null` values\nBy default, `null` values are treated as being larger than any other value. With an ascending sort order, `null` values are sorted last, and with a descending sort order, `null` values are sorted first. You can change that by providing `NULLS FIRST` or `NULLS LAST`:\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| SORT first_name ASC NULLS FIRST\n```\n            ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.statsby",{defaultMessage:"STATS ... BY"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.statsby.markdown",{defaultMessage:"### STATS ... BY\nUse `STATS ... BY` to group rows according to a common value and calculate one or more aggregated values over the grouped rows.\n\n```\nFROM employees\n| STATS count = COUNT(languages) BY languages\n```\n\nIf `BY` is omitted, the output table contains exactly one row with the aggregations applied over the entire dataset:\n\n```\nFROM employees\n| STATS avg_lang = AVG(languages)\n```\n\nIt's possible to calculate multiple values:\n\n```\nFROM employees\n| STATS avg_lang = AVG(languages), max_lang = MAX(languages)\n```\n\nIt's also possible to group by multiple values (only supported for long and keyword family fields):\n\n```\nFROM employees\n| EVAL hired = DATE_FORMAT(hire_date, \"YYYY\")\n| STATS avg_salary = AVG(salary) BY hired, languages.long\n| EVAL avg_salary = ROUND(avg_salary)\n| SORT hired, languages.long\n```\n\nRefer to **Aggregation functions** for a list of functions that can be used with `STATS ... BY`.\n            ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.where",{defaultMessage:"WHERE"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.where.markdown",{defaultMessage:"### WHERE\nUse `WHERE` to produce a table that contains all the rows from the input table for which the provided condition evaluates to `true`:\n              \n```\nFROM employees\n| KEEP first_name, last_name, still_hired\n| WHERE still_hired == true\n```\n\n#### Operators\n\nRefer to **Operators** for an overview of the supported operators.\n\n#### Functions\n`WHERE` supports various functions for calculating values. Refer to **Functions** for more information.\n            ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})}]},l={label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.functions",{defaultMessage:"Functions"}),description:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.functionsDocumentationESQLDescription",{defaultMessage:"Functions are supported by ROW, EVAL and WHERE."}),items:[{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.absFunction",{defaultMessage:"ABS"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.absFunction.markdown",{defaultMessage:"### ABS\nReturns the absolute value.\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| EVAL abs_height = ABS(0.0 - height)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.acosFunction",{defaultMessage:"ACOS"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.acosFunction.markdown",{defaultMessage:"### ACOS\nInverse cosine trigonometric function.\n\n```\nROW a=.9\n| EVAL acos=ACOS(a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.asinFunction",{defaultMessage:"ASIN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.asinFunction.markdown",{defaultMessage:"### ASIN\nInverse sine trigonometric function.\n\n```\nROW a=.9\n| EVAL asin=ASIN(a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.atanFunction",{defaultMessage:"ATAN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.atanFunction.markdown",{defaultMessage:"### ATAN\nInverse tangent trigonometric function.\n\n```\nROW a=12.9\n| EVAL atan=ATAN(a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.atan2Function",{defaultMessage:"ATAN2"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.atan2Function.markdown",{defaultMessage:"### ATAN2\nThe angle between the positive x-axis and the ray from the origin to the point (x , y) in the Cartesian plane.\n\n```\nROW y=12.9, x=.6\n| EVAL atan2=ATAN2(y, x)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.autoBucketFunction",{defaultMessage:"AUTO_BUCKET"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.autoBucketFunction.markdown",{defaultMessage:'### AUTO_BUCKET\nCreates human-friendly buckets and returns a `datetime` value for each row that corresponds to the resulting bucket the row falls into. Combine `AUTO_BUCKET`with `STATS ... BY` to create a date histogram.\n\nYou provide a target number of buckets, a start date, and an end date, and it picks an appropriate bucket size to generate the target number of buckets or fewer. For example, this asks for at most 20 buckets over a whole year, which picks monthly buckets:\n\n```\nROW date=TO_DATETIME("1985-07-09T00:00:00.000Z")\n| EVAL bucket=AUTO_BUCKET(date, 20, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")\n```\n\nReturning:\n```\n1985-07-09T00:00:00.000Z | 1985-07-01T00:00:00.000Z\n```\n\nThe goal isn\'t to provide *exactly* the target number of buckets, it\'s to pick a\nrange that people are comfortable with that provides at most the target number of\nbuckets.\n\nIf you ask for more buckets then `AUTO_BUCKET` can pick a smaller range. For example,\nasking for at most 100 buckets in a year will get you week long buckets:\n\n```\nROW date=TO_DATETIME("1985-07-09T00:00:00.000Z")\n| EVAL bucket=AUTO_BUCKET(date, 100, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")\n```\n\nReturning:\n```\n1985-07-09T00:00:00.000Z | 1985-07-08T00:00:00.000Z\n```\n\n`AUTO_BUCKET` does not filter any rows. It only uses the provided time range to pick a good bucket size. For rows with a date outside of the range, it returns a datetime that corresponds to a bucket outside the range. Combine `AUTO_BUCKET` with `WHERE` to filter rows.\n\nA more complete example might look like:\n\n```\nFROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| EVAL bucket = AUTO_BUCKET(hire_date, 20, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")\n| STATS AVG(salary) BY bucket\n| SORT bucket\n```\n\nReturning:\n```\n46305.0 | 1985-02-01T00:00:00.000Z\n44817.0 | 1985-05-01T00:00:00.000Z\n62405.0 | 1985-07-01T00:00:00.000Z\n49095.0 | 1985-09-01T00:00:00.000Z\n51532.0 | 1985-10-01T00:00:00.000Z\n54539.75 | 1985-11-01T00:00:00.000\n```\n\nNOTE: `AUTO_BUCKET` does not create buckets that don’t match any documents. That’s why the example above is missing 1985-03-01 and other dates.\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.caseFunction",{defaultMessage:"CASE"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.caseFunction.markdown",{defaultMessage:'### CASE\nAccepts pairs of conditions and values. The function returns the value that belongs to the first condition that evaluates to `true`. If the number of arguments is odd, the last argument is the default value which is returned when no condition matches.\n\n```\nFROM employees\n| EVAL type = CASE(\n    languages <= 1, "monolingual",\n    languages <= 2, "bilingual",\n     "polyglot")\n| KEEP first_name, last_name, type\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.ceilFunction",{defaultMessage:"CEIL"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.ceilFunction.markdown",{defaultMessage:"### CEIL\nRound a number up to the nearest integer.\n\n```\nROW a=1.8\n| EVAL a=CEIL(a)\n```\n\nNote: This is a noop for `long` (including unsigned) and `integer`. For `double` this picks the the closest `double` value to the integer similar to Java's `Math.ceil`.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.cidrMatchFunction",{defaultMessage:"CIDR_MATCH"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.cidrMatchFunction.markdown",{defaultMessage:'### CIDR_MATCH\nReturns `true` if the provided IP is contained in one of the provided CIDR blocks. \n\n`CIDR_MATCH` accepts two or more arguments. The first argument is the IP address of type `ip` (both IPv4 and IPv6 are supported). Subsequent arguments are the CIDR blocks to test the IP against.\n\n```\nFROM hosts\n| WHERE CIDR_MATCH(ip, "127.0.0.2/32", "127.0.0.3/32")\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.coalesceFunction",{defaultMessage:"COALESCE"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.coalesceFunction.markdown",{defaultMessage:'### COALESCE\nReturns the first non-null value.\n\n```\nROW a=null, b="b"\n| EVAL COALESCE(a, b)\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.concatFunction",{defaultMessage:"CONCAT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.concatFunction.markdown",{defaultMessage:'### CONCAT\nConcatenates two or more strings.\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| EVAL fullname = CONCAT(first_name, " ", last_name)\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.cosFunction",{defaultMessage:"COS"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.cosFunction.markdown",{defaultMessage:"### COS\nCosine trigonometric function.\n\n```\nROW a=1.8\n| EVAL cos=COS(a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.coshFunction",{defaultMessage:"COSH"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.coshFunction.markdown",{defaultMessage:"### COSH\nCosine hyperbolic function.\n\n```\nROW a=1.8\n| EVAL cosh=COSH(a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.dateExtractFunction",{defaultMessage:"DATE_EXTRACT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.dateExtractFunction.markdown",{defaultMessage:'### DATE_EXTRACT\nExtracts parts of a date, like year, month, day, hour. The supported field types are those provided by Java\'s `java.time.temporal.ChronoField`.\n\n```\nROW date = DATE_PARSE("yyyy-MM-dd", "2022-05-06")\n| EVAL year = DATE_EXTRACT("year", date)\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.dateFormatFunction",{defaultMessage:"DATE_FORMAT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.dateFormatFunction.markdown",{defaultMessage:"### DATE_FORMAT\nReturns a string representation of a date in the provided format. If no format is specified, the `yyyy-MM-dd'T'HH:mm:ss.SSSZ` format is used.\n\n```\nFROM employees\n| KEEP first_name, last_name, hire_date\n| EVAL hired = DATE_FORMAT(\"YYYY-MM-dd\", hire_date)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.dateParseFunction",{defaultMessage:"DATE_PARSE"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.dateParseFunction.markdown",{defaultMessage:'### DATE_PARSE\nConverts a string to a date, in the provided format. If no format is specified, the `yyyy-MM-dd\'T\'HH:mm:ss.SSSZ` format is used.\n\n```\nROW date_string = "2022-05-06"\n| EVAL date = DATE_PARSE("yyyy-MM-dd", date_string)\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.dateTruncFunction",{defaultMessage:"DATE_TRUNC"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.dateTruncFunction.markdown",{defaultMessage:"### DATE_TRUNC\nRounds down a date to the closest interval.\n\n```\nFROM employees\n| EVAL year_hired = DATE_TRUNC(1 year, hire_date)\n| STATS count(emp_no) BY year_hired\n| SORT year_hired\n```\n\nIntervals can be expressed using the timespan literal syntax. Timespan literals are a combination of a number and a qualifier. These qualifiers are supported:\n\n* `millisecond`/milliseconds\n* `second`/`seconds`\n* `minute`/`minutes`\n* `hour`/`hours`\n* `day`/`days`\n* `week`/`weeks`\n* `month`/`months`\n* `year`/`years`\n\nTimespan literals are not whitespace sensitive. These expressions are all valid:\n\n* `1day`\n* `1 day`\n* `1      day`\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.eFunction",{defaultMessage:"E"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.eFunction.markdown",{defaultMessage:"### E\nEuler’s number.\n\n```\nROW E()\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.endsWithFunction",{defaultMessage:"ENDS_WITH"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.endsWithFunction.markdown",{defaultMessage:'### ENDS_WITH\nReturns a boolean that indicates whether a keyword string ends with another string:\n\n```\nFROM employees\n| KEEP last_name\n| EVAL ln_E = ENDS_WITH(last_name, "d")\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.floorFunction",{defaultMessage:"FLOOR"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.floorFunction.markdown",{defaultMessage:"### FLOOR\nRound a number down to the nearest integer.\n\n```\nROW a=1.8\n| EVAL a=FLOOR(a)\n```\n\nNote: this is a noop for `long` (including unsigned) and `integer`. For `double` this picks the the closest `double` value to the integer similar to Java's `Math.floor`.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.greatestFunction",{defaultMessage:"GREATEST"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.greatestFunction.markdown",{defaultMessage:"### GREATEST\nReturns the maximum value from many columns. This is similar to `MV_MAX` except it's intended to run on multiple columns at once.\n\n```\nROW a = 10, b = 20\n| EVAL g = GREATEST(a, b);\n```\n\nNote: when run on `keyword` or `text` fields, this will return the last string in alphabetical order. When run on `boolean` columns this will return `true` if any values are `true`.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.isFiniteFunction",{defaultMessage:"IS_FINITE"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.isFiniteFunction.markdown",{defaultMessage:"### IS_FINITE\nReturns a boolean that indicates whether its input is a finite number.\n\n```\nROW d = 1.0 \n| EVAL s = IS_FINITE(d/0)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.isInfiniteFunction",{defaultMessage:"IS_INFINITE"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.isInfiniteFunction.markdown",{defaultMessage:"### IS_INFINITE\nReturns a boolean that indicates whether its input is infinite.\n\n```\nROW d = 1.0 \n| EVAL s = IS_INFINITE(d/0)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.isNanFunction",{defaultMessage:"IS_NAN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.isNanFunction.markdown",{defaultMessage:"### IS_NAN\nReturns a boolean that indicates whether its input is not a number.\n\n```\nROW d = 1.0 \n| EVAL s = IS_NAN(d)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.leastFunction",{defaultMessage:"LEAST"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.leastFunction.markdown",{defaultMessage:"### LEAST\nReturns the minimum value from many columns. This is similar to `MV_MIN` except it's intended to run on multiple columns at once.\n\n```\nROW a = 10, b = 20\n| EVAL l = LEAST(a, b)\n```\n\nNote: when run on `keyword` or `text` fields, this will return the first string in alphabetical order. When run on `boolean` columns this will return `false` if any values are `false`.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.leftFunction",{defaultMessage:"LEFT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.leftFunction.markdown",{defaultMessage:"### LEFT\nReturn the substring that extracts `length` chars from the `string`, starting from the left.\n\n```\nFROM employees\n| KEEP last_name\n| EVAL left = LEFT(last_name, 3)\n| SORT last_name ASC\n| LIMIT 5\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.lengthFunction",{defaultMessage:"LENGTH"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.lengthFunction.markdown",{defaultMessage:"### LENGTH\nReturns the character length of a string.\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| EVAL fn_length = LENGTH(first_name)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.log10Function",{defaultMessage:"LOG10"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.log10Function.markdown",{defaultMessage:"### LOG10\nReturns the log base 10. The input can be any numeric value, the return value is always a double.\n\nLogs of negative numbers are NaN. Logs of infinites are infinite, as is the log of 0.\n\n```\nROW d = 1000.0\n| EVAL s = LOG10(d)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.ltrimunction",{defaultMessage:"LTRIM"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.ltrimFunction.markdown",{defaultMessage:'### LTRIM\nRemoves leading whitespaces from strings.\n\n```\nROW message = "   some text  ",  color = " red "\n| EVAL message = LTRIM(message)\n| EVAL color = LTRIM(color)\n| EVAL message = CONCAT("\'", message, "\'")\n| EVAL color = CONCAT("\'", color, "\'")\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvAvgFunction",{defaultMessage:"MV_AVG"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvAvgFunction.markdown",{defaultMessage:"### MV_AVG\nConverts a multivalued field into a single valued field containing the average of all of the values. For example:\n\n```\nROW a=[3, 5, 1, 6]\n| EVAL avg_a = MV_AVG(a)\n```\n\nReturning:\n\n```\n[3, 5, 1, 6] | 3.75\n```\n\nNOTE: The output type is always a double and the input type can be any number.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvConcatFunction",{defaultMessage:"MV_CONCAT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvConcatFunction.markdown",{defaultMessage:'### MV_CONCAT\nConverts a multivalued string field into a single valued field containing the concatenation of all values separated by a delimiter:\n\n```\nROW a=["foo", "zoo", "bar"]\n| EVAL j = MV_CONCAT(a, ", ")\n```\n\nReturning:\n\n```\n["foo", "zoo", "bar"] | "foo, zoo, bar"\n```\n\nIf you want to join non-string fields call `TO_STRING` on them first:\n\n```\nROW a=[10, 9, 8]\n| EVAL j = MV_CONCAT(TO_STRING(a), ", ")\n```\n\nReturning:\n\n```\n[10, 9, 8] | "10, 9, 8"\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvCountFunction",{defaultMessage:"MV_COUNT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvCountFunction.markdown",{defaultMessage:'### MV_COUNT\nConverts a multivalued field into a single valued field containing a count of the number of values:\n\n```\nROW a=["foo", "zoo", "bar"]\n| EVAL count_a = MV_COUNT(a)\n```\n\nReturning:\n\n```\n["foo", "zoo", "bar"] | 3\n```\n\nNOTE: This function accepts all types and always returns an integer.\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvDedupeFunction",{defaultMessage:"MV_DEDUPE"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvDedupeFunction.markdown",{defaultMessage:'### MV_DEDUPE\nRemoves duplicates from a multivalued field. For example:\n\n```\nROW a=["foo", "foo", "bar", "foo"]\n| EVAL dedupe_a = MV_DEDUPE(a)\n```\n\nReturning:\n\n```\n["foo", "foo", "bar", "foo"] | ["foo", "bar"]\n```\n\nNOTE: `MV_DEDUPE` may, but won’t always, sort the values in the field.\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvMaxFunction",{defaultMessage:"MV_MAX"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvMaxFunction.markdown",{defaultMessage:'### MV_MAX\nConverts a multivalued field into a single valued field containing the maximum value. For example:\n\n```\nROW a=[3, 5, 1]\n| EVAL max_a = MV_MAX(a)\n```\n\nReturning:\n\n```\n[3, 5, 1] | 5\n```\n\nIt can be used by any field type, including `keyword` fields. In that case picks the last string, comparing their utf-8 representation byte by byte:\n\n```\nROW a=["foo", "zoo", "bar"]\n| EVAL max_a = MV_MAX(a)\n```\n\nReturning:\n\n```\n["foo", "zoo", "bar"] | "zoo"\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvMedianFunction",{defaultMessage:"MV_MEDIAN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvMedianFunction.markdown",{defaultMessage:"### MV_MEDIAN\nConverts a multivalued field into a single valued field containing the median value. For example:\n\n```\nROW a=[3, 5, 1]\n| EVAL median_a = MV_MEDIAN(a)\n```\n\nReturning:\n\n```\n[3, 5, 1] | 3\n```\n\nIt can be used by any numeric field type and returns a value of the same type. If the row has an even number of values for a column the result will be the average of the middle two entries. If the field is not floating point then the average rounds **down**:\n\n```\nROW a=[3, 7, 1, 6]\n| EVAL median_a = MV_MEDIAN(a)\n```\n\nReturning:\n\n```\n[3, 7, 1, 6] | 4\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvMinFunction",{defaultMessage:"MV_MIN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvMinFunction.markdown",{defaultMessage:'### MV_MIN\nConverts a multivalued field into a single valued field containing the minimum value. For example:\n\n```\nROW a=[2, 1]\n| EVAL min_a = MV_MIN(a)\n```\n\nReturning:\n\n```\n[2, 1] | 1\n```\n\nIt can be used by any field type, including `keyword` fields. In that case picks the last string, comparing their utf-8 representation byte by byte:\n\n```\nROW a=["foo", "bar"]\n| EVAL min_a = MV_MIN(a)\n```\n\nReturning:\n\n```\n["foo", "bar"] | "bar"\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvSumFunction",{defaultMessage:"MV_SUM"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.mvSumFunction.markdown",{defaultMessage:"### MV_SUM\nConverts a multivalued field into a single valued field containing the sum of all of the values. For example:\n```\nROW a=[3, 5, 6]\n| EVAL sum_a = MV_SUM(a)\n```\n\nReturning:\n\n```\n[3, 5, 6] | 14\n```\n\nNOTE: The input type can be any number and the output type is the same as the input type.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.nowFunction",{defaultMessage:"NOW"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.nowFunction.markdown",{defaultMessage:"### NOW\nReturns current date and time.\n\n```\nROW current_date = NOW()\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.piFunction",{defaultMessage:"PI"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.piFunction.markdown",{defaultMessage:"### PI\nThe ratio of a circle's circumference to its diameter.\n\n```\nROW PI()\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.powFunction",{defaultMessage:"POW"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.powFunction.markdown",{defaultMessage:"### POW\nReturns the value of a base (first argument) raised to the power of an exponent (second argument). Both arguments must be numeric. The output is always a double. Note that it is still possible to overflow a double result here; in that case, `null` will be returned.\n\n```\nROW base = 2.0, exponent = 2.0 \n| EVAL s = POW(base, exponent)\n```\n\n#### Fractional exponents\n\nThe exponent can be a fraction, which is similar to performing a root. For example, the exponent of 0.5 will give the square root of the base:\n\n```\nROW base = 4, exponent = 0.5\n| EVAL s = POW(base, exponent)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.rightFunction",{defaultMessage:"RIGHT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.rightFunction.markdown",{defaultMessage:"### RIGHT\nReturn the substring that extracts `length` chars from the string starting from the `right`.\n\n```\nFROM employees\n| KEEP last_name\n| EVAL right = RIGHT(last_name, 3)\n| SORT last_name ASC\n| LIMIT 5\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.roundFunction",{defaultMessage:"ROUND"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.roundFunction.markdown",{defaultMessage:"### ROUND\nRounds a number to the closest number with the specified number of digits. Defaults to 0 digits if no number of digits is provided. If the specified number of digits is negative, rounds to the number of digits left of the decimal point.\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| EVAL height = ROUND(height * 3.281, 1)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.rtrimFunction",{defaultMessage:"RTRIM"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.rtrimFunction.markdown",{defaultMessage:'### RTRIM\nRemoves trailing whitespaces from strings.\n\n```\nROW message = "   some text  ",  color = " red "\n| EVAL message = RTRIM(message)\n| EVAL color = RTRIM(color)\n| EVAL message = CONCAT("\'", message, "\'")\n| EVAL color = CONCAT("\'", color, "\'")\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.sinFunction",{defaultMessage:"SIN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.sinFunction.markdown",{defaultMessage:"### SIN\nSine trigonometric function.\n\n```\nROW a=1.8\n| EVAL sin=SIN(a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.sinhFunction",{defaultMessage:"SINH"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.sinhFunction.markdown",{defaultMessage:"### SINH\nSine hyperbolic function.\n\n```\nROW a=1.8\n| EVAL sinh=SINH(a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.splitFunction",{defaultMessage:"SPLIT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.splitFunction.markdown",{defaultMessage:'### SPLIT\nSplits a single valued string into multiple strings. For example:\n\n```\nROW words="foo;bar;baz;qux;quux;corge"\n| EVAL word = SPLIT(words, ";")\n```\n\nWhich splits `"foo;bar;baz;qux;quux;corge"` on `;` and returns an array:\n\n```\nfoo;bar;baz;qux;quux;corge | [foo,bar,baz,qux,quux,corge]\n```\n\nNOTE: Only single byte delimiters are currently supported.\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.sqrtFunction",{defaultMessage:"SQRT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.sqrtFunction.markdown",{defaultMessage:"### SQRT\nReturns the square root of a number. The input can be any numeric value, the return value is always a double.\n\nSquare roots of negative numbers are NaN. Square roots of infinites are infinite.\n\n```\nROW d = 100.0\n| EVAL s = SQRT(d)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.startsWithFunction",{defaultMessage:"STARTS_WITH"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.startsWithFunction.markdown",{defaultMessage:'### STARTS_WITH\nReturns a boolean that indicates whether a keyword string starts with another string:\n\n```\nFROM employees\n| KEEP first_name, last_name, height\n| EVAL ln_S = STARTS_WITH(last_name, "S")\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.substringFunction",{defaultMessage:"SUBSTRING"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.substringFunction.markdown",{defaultMessage:"### SUBSTRING\nReturns a substring of a string, specified by a start position and an optional length. This example returns the first three characters of every last name:\n\n```\nFROM employees\n| KEEP last_name\n| EVAL ln_sub = SUBSTRING(last_name, 1, 3)\n```\n\nA negative start position is interpreted as being relative to the end of the string. This example returns the last three characters of of every last name:\n\n```\nFROM employees\n| KEEP last_name\n| EVAL ln_sub = SUBSTRING(last_name, -3, 3)\n```\n\nIf length is omitted, substring returns the remainder of the string. This example returns all characters except for the first:\n\n```\nFROM employees\n| KEEP last_name\n| EVAL ln_sub = SUBSTRING(last_name, 2)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.tanFunction",{defaultMessage:"TAN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.tanFunction.markdown",{defaultMessage:"### TAN\nTangent trigonometric function.\n\n```\nROW a=1.8\n| EVAL tan=TAN(a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.tanhFunction",{defaultMessage:"TANH"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.tanhFunction.markdown",{defaultMessage:"### TANH\nTangent hyperbolic function.\n\n```\nROW a=1.8\n| EVAL tanh=TANH(a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.tauFunction",{defaultMessage:"TAU"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.tauFunction.markdown",{defaultMessage:"### TAU\nThe ratio of a circle's circumference to its radius.\n\n```\nROW TAU()\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toBooleanFunction",{defaultMessage:"TO_BOOLEAN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toBooleanFunction.markdown",{defaultMessage:'### TO_BOOLEAN\nConverts an input value to a boolean value.\n\nThe input can be a single- or multi-valued field or an expression. The input type must be of a string or numeric type.\n\nA string value of **"true"** will be case-insensitive converted to the Boolean **true**. For anything else, including the empty string, the function will return **false**. For example:\n\n```\nROW str = ["true", "TRuE", "false", "", "yes", "1"]\n| EVAL bool = TO_BOOLEAN(str)\n```\n\nReturning:\n\n```\n["true", "TRuE", "false", "", "yes", "1"] | [true, true, false, false, false, false]\n```\n\nThe numerical value of **0** will be converted to **false**, anything else will be converted to **true**.\n\nAlias: TO_BOOL\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toCartesianpointFunction",{defaultMessage:"TO_CARTESIANPOINT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toCartesianpointFunction.markdown",{defaultMessage:'### TO_CARTESIANPOINT\nConverts an input value to a `point` value.\n\nThe input can be a single- or multi-valued field or an expression. The input type must be a string or a cartesian point.\n\nA string will only be successfully converted if it respects the [WKT Point](https://en.wikipedia.org/wiki/Well-known_text_representation_of_geometry) format:\n\n```\nROW wkt = ["POINT(4297.11 -1475.53)", "POINT(7580.93 2272.77)"]\n| MV_EXPAND wkt\n| EVAL pt = TO_CARTESIANPOINT(wkt)\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toDatetimeFunction",{defaultMessage:"TO_DATETIME"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toDatetimeFunction.markdown",{defaultMessage:'### TO_DATETIME\nConverts an input value to a date value.\n\nThe input can be a single- or multi-valued field or an expression. The input type must be of a string or numeric type.\n\nA string will only be successfully converted if it’s respecting the format `yyyy-MM-dd\'T\'HH:mm:ss.SSS\'Z\'`. For example:\n\n```\nROW string = ["1953-09-02T00:00:00.000Z", "1964-06-02T00:00:00.000Z", "1964-06-02 00:00:00"]\n| EVAL datetime = TO_DATETIME(string)\n```\n\nReturning:\n\n```\n["1953-09-02T00:00:00.000Z", "1964-06-02T00:00:00.000Z", "1964-06-02 00:00:00"] | [1953-09-02T00:00:00.000Z, 1964-06-02T00:00:00.000Z]\n```\n\nNote that in this example, the last value in the source multi-valued field has not been converted. The reason being that if the date format is not respected, the conversion will result in a **null** value.\n\nIf the input parameter is of a numeric type, its value will be interpreted as milliseconds since the Unix epoch. For example:\n\n```\nROW int = [0, 1]\n| EVAL dt = TO_DATETIME(int)\n```\n\nReturning:\n\n```\n[0, 1] | [1970-01-01T00:00:00.000Z, 1970-01-01T00:00:00.001Z]\n```\n\nAlias: TO_DT\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toDegreesFunction",{defaultMessage:"TO_DEGREES"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toDegreesFunction.markdown",{defaultMessage:"### TO_DEGREES\nConverts a number in radians to degrees.\n\nThe input can be a single- or multi-valued field or an expression. The input type must be of a numeric type and result is always `double`.\n\n```\nROW rad = [1.57, 3.14, 4.71]\n| EVAL deg = TO_DEGREES(rad)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toDoubleFunction",{defaultMessage:"TO_DOUBLE"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toDoubleFunction.markdown",{defaultMessage:'### TO_DOUBLE\nConverts an input value to a double value.\n\nThe input can be a single- or multi-valued field or an expression. The input type must be of a boolean, date, string or numeric type.\n\nExample:\n\n```\nROW str1 = "5.20128E11", str2 = "foo"\n| EVAL dbl = TO_DOUBLE("520128000000"), dbl1 = TO_DOUBLE(str1), dbl2 = TO_DOUBLE(str2)\n```\n\nReturning:\n\n```\n5.20128E11 | foo | 5.20128E11 | 5.20128E11 | null\n```\n\nNote that in this example, the last conversion of the string isn’t possible. When this happens, the result is a **null** value.\n\nIf the input parameter is of a date type, its value will be interpreted as milliseconds since the Unix epoch, converted to double.\n\nBoolean **true** will be converted to double **1.0**, **false** to **0.0**.\n\nAlias: TO_DBL\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toGeopointFunction",{defaultMessage:"TO_GEOPOINT"}),description:Object(i.jsx)(s.Markdown,{openLinksInNewTab:!0,markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toGeopointFunction.markdown",{defaultMessage:'### TO_GEOPOINT\nConverts an input value to a `geo_point` value.\n\nThe input can be a single- or multi-valued field or an expression. The input type must be a string or a `geo_point`.\n\nA string will only be successfully converted if it respects the [WKT Point](https://en.wikipedia.org/wiki/Well-known_text_representation_of_geometry) format:\n\n```\nROW wkt = "POINT(42.97109630194 14.7552534413725)"\n| EVAL pt = TO_GEOPOINT(wkt)\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toIntegerFunction",{defaultMessage:"TO_INTEGER"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toIntegerFunction.markdown",{defaultMessage:"### TO_INTEGER\nConverts an input value to an integer value.\n\nThe input can be a single- or multi-valued field or an expression. The input type must be of a boolean, date, string or numeric type.\n\nExample:\n\n```\nROW long = [5013792, 2147483647, 501379200000]\n| EVAL int = TO_INTEGER(long)\n```\n\nReturning:\n\n```\n[5013792, 2147483647, 501379200000] | [5013792, 2147483647]\n```\n\nNote that in this example, the last value of the multi-valued field cannot be converted as an integer. When this happens, the result is a **null** value.\n\nIf the input parameter is of a date type, its value will be interpreted as milliseconds since the Unix epoch, converted to integer.\n\nBoolean **true** will be converted to integer **1**, **false** to **0**.\n\nAlias: TO_INT\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toIpFunction",{defaultMessage:"TO_IP"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toIpFunction.markdown",{defaultMessage:'### TO_IP\nConverts an input string to an IP value.\n\nThe input can be a single- or multi-valued field or an expression.\n\nExample:\n\n```\nROW str1 = "1.1.1.1", str2 = "foo"\n| EVAL ip1 = TO_IP(str1), ip2 = TO_IP(str2)\n| WHERE CIDR_MATCH(ip1, "1.0.0.0/8")\n```\n\nReturning:\n\n```\n1.1.1.1 | foo | 1.1.1.1 | null\n```\n\nNote that in the example above the last conversion of the string isn’t possible. When this happens, the result is a **null** value.\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toLongFunction",{defaultMessage:"TO_LONG"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toLongFunction.markdown",{defaultMessage:'### TO_LONG\nConverts an input value to an long value.\n\nThe input can be a single- or multi-valued field or an expression. The input type must be of a boolean, date, string or numeric type.\n\nExample:\n\n```\nROW str1 = "2147483648", str2 = "2147483648.2", str3 = "foo"\n| EVAL long1 = TO_LONG(str1), long2 = TO_LONG(str2), long3 = TO_LONG(str3)\n```\n\nReturning:\n\n```\n2147483648 | 2147483648.2 | foo | 2147483648 | 2147483648 | null\n```\n\nNote that in this example, the last conversion of the string isn\'t possible. When this happens, the result is a **null** value. \n\nIf the input parameter is of a date type, its value will be interpreted as milliseconds since the Unix epoch, converted to integer.\n\nBoolean `true` will be converted to long `1`, `false` to `0`.\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toRadiansFunction",{defaultMessage:"TO_RADIANS"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toRadiansFunction.markdown",{defaultMessage:"### TO_RADIANS\nConverts a number in degrees to radians.\n\nThe input can be a single- or multi-valued field or an expression. The input type must be of a numeric type and result is always `double`.\n\n```\nROW deg = [90.0, 180.0, 270.0]\n| EVAL rad = TO_RADIANS(deg)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toStringFunction",{defaultMessage:"TO_STRING"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toStringFunction.markdown",{defaultMessage:"### TO_STRING\nConverts a field into a string. For example:\n\n```\nROW a=10\n| EVAL j = TO_STRING(a)\n```\n\nIt also works fine on multivalued fields:\n\n```\nROW a=[10, 9, 8]\n| EVAL j = TO_STRING(a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toUnsignedLongFunction",{defaultMessage:"TO_UNSIGNED_LONG"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toUnsignedLongFunction.markdown",{defaultMessage:'### TO_UNSIGNED_LONG\nConverts an input value to an unsigned long value.\n\nThe input can be a single- or multi-valued field or an expression. The input type must be of a boolean, date, string or numeric type.\n\n```\nROW str1 = "2147483648", str2 = "2147483648.2", str3 = "foo"\n| EVAL long1 = TO_UNSIGNED_LONG(str1), long2 = TO_ULONG(str2), long3 = TO_UL(str3)\n```\n\nNote that in this example, the last conversion of the string isn\'t possible. When this happens, the result is a **null** value. In this case a Warning header is added to the response. The header will provide information on the source of the failure:\n\n```\n"Line 1:133: evaluation of [TO_UL(str3)] failed, treating result as null. Only first 20 failures recorded."\n```\n\nA following header will contain the failure reason and the offending value:\n\n```\n"java.lang.NumberFormatException: Character f is neither a decimal digit number, decimal point, nor "e" notation exponential mark."\n```\n\nIf the input parameter is of a date type, its value will be interpreted as milliseconds since the Unix epoch, converted to unsigned long.\n\nBoolean `true` will be converted to unsigned long `1`, `false` to `0`.\n\nAlias: TO_ULONG, TO_UL\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toVersionFunction",{defaultMessage:"TO_VERSION"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.toVersionFunction.markdown",{defaultMessage:'### TO_VERSION\nConverts an input string to a version value. For example:\n\n```\nROW v = TO_VERSION("1.2.3")\n```\n\nReturning:\n\n```\n1.2.3\n```\n\nAlias: TO_VER\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.trimFunction",{defaultMessage:"TRIM"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.trimFunction.markdown",{defaultMessage:'### TRIM\nRemoves leading and trailing whitespaces from strings.\n\n```\nROW message = "   some text  ",  color = " red "\n| EVAL message = TRIM(message)\n| EVAL color = TRIM(color)\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})}]},u={label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.aggregationFunctions",{defaultMessage:"Aggregation functions"}),description:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.aggregationFunctionsDocumentationESQLDescription",{defaultMessage:"These functions can by used with STATS...BY:"}),items:[{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.avgFunction",{defaultMessage:"AVG"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.avgFunction.markdown",{defaultMessage:"### AVG\nThe average of a numeric field.\n\n```\nFROM employees\n| STATS AVG(height)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.countFunction",{defaultMessage:"COUNT"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.countFunction.markdown",{defaultMessage:"### COUNT\nCounts field values.\n\n```\nFROM employees\n| STATS COUNT(height)\n```\n\nCan take any field type as input and the result is always a `long` no matter the input type.\n\nNOTE: There isn’t yet a `COUNT(*)`. Please count a single valued field if you need a count of rows.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.countDistinctFunction",{defaultMessage:"COUNT_DISTINCT"}),description:Object(i.jsx)(s.Markdown,{openLinksInNewTab:!0,markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.countDistinctFunction.markdown",{defaultMessage:"### COUNT_DISTINCT\n  The approximate number of distinct values.\n\n  ```\n  FROM hosts\n  | STATS COUNT_DISTINCT(ip0), COUNT_DISTINCT(ip1)\n  ```\n\n  The `COUNT_DISTINCT` function is approximate, based on the HyperLogLog++ algorithm. Refer to the [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-cardinality-aggregation.html#_counts_are_approximate) for more information. The precision is configurable, using an optional second parameter:\n\n  ```\n  FROM hosts\n  | STATS COUNT_DISTINCT(ip0, 80000), COUNT_DISTINCT(ip1, 5)\n  ```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.maxFunction",{defaultMessage:"MAX"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.maxFunction.markdown",{defaultMessage:"### MAX\nThe maximum value of a numeric field.\n\n```\nFROM employees\n| STATS MAX(languages)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.medianFunction",{defaultMessage:"MEDIAN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.medianFunction.markdown",{defaultMessage:"### MEDIAN\nThe value that is greater than half of all values and less than half of all values, also known as the 50% percentile.\n\n```\nFROM employees\n| STATS MEDIAN(salary)\n```\n\nNOTE: Like `PERCENTILE`, `MEDIAN` is usually approximate, based on the TDigest algorithm. `MEDIAN` is also non-deterministic. This means you can get slightly different results using the same data.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.medianAbsoluteDeviationFunction",{defaultMessage:"MEDIAN_ABSOLUTE_DEVIATION"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.medianAbsoluteDeviationFunction.markdown",{defaultMessage:"### MEDIAN_ABSOLUTE_DEVIATION\nThe median absolute deviation, a measure of variability. It is a robust statistic, meaning that it is useful for describing data that may have outliers, or may not be normally distributed. For such data it can be more descriptive than standard deviation.\n\nIt is calculated as the median of each data point’s deviation from the median of the entire sample. That is, for a random variable X, the median absolute deviation is `median(|median(X) - Xi|)`.\n\n```\nFROM employees\n| STATS MEDIAN(salary), MEDIAN_ABSOLUTE_DEVIATION(salary)\n```\n\nNOTE: Like `PERCENTILE`, `MEDIAN_ABSOLUTE_DEVIATION` is usually approximate, based on the TDigest algorithm. `MEDIAN_ABSOLUTE_DEVIATION` is also non-deterministic. This means you can get slightly different results using the same data.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.minFunction",{defaultMessage:"MIN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.minFunction.markdown",{defaultMessage:"### MIN\nThe minimum value of a numeric field.\n\n```\nFROM employees\n| STATS MIN(languages)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.percentileFunction",{defaultMessage:"PERCENTILE"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.percentileFunction.markdown",{defaultMessage:"### PERCENTILE\nThe value at which a certain percentage of observed values occur. For example, the 95th percentile is the value which is greater than 95% of the observed values and the 50th percentile is the `MEDIAN`.\n\n```\nFROM employees\n| STATS p0 = PERCENTILE(salary,  0)\n     , p50 = PERCENTILE(salary, 50)\n     , p99 = PERCENTILE(salary, 99)\n```\n\nNOTE: `PERCENTILE` is usually approximate, based on the TDigest algorithm. `PERCENTILE` is also non-deterministic. This means you can get slightly different results using the same data.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.sumFunction",{defaultMessage:"SUM"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.sumFunction.markdown",{defaultMessage:"### SUM\nThe sum of a numeric field.\n\n```\nFROM employees\n| STATS SUM(languages)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})}]},c={label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.operators",{defaultMessage:"Operators"}),description:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.operatorsDocumentationESQLDescription",{defaultMessage:"ES|QL supports the following operators:"}),items:[{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.binaryOperators",{defaultMessage:"Binary operators"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.binaryOperators.markdown",{defaultMessage:"### Binary operators\nThese binary comparison operators are supported:\n\n* equality: `==`\n* inequality: `!=`\n* less than: `<`\n* less than or equal: `<=`\n* larger than: `>`\n* larger than or equal: `>=`\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.booleanOperators",{defaultMessage:"Boolean operators"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.booleanOperators.markdown",{defaultMessage:"### Boolean operators\nThe following boolean operators are supported:\n\n* `AND`\n* `OR`\n* `NOT`\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.inOperator",{defaultMessage:"IN"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.inOperator.markdown",{defaultMessage:"### IN\nThe `IN` operator allows testing whether a field or expression equals an element in a list of literals, fields or expressions:\n\n```\nROW a = 1, b = 4, c = 3\n| WHERE c-a IN (3, b / 2, a)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.stringOperators",{defaultMessage:"LIKE and RLIKE"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.stringOperators.markdown",{defaultMessage:'### LIKE and RLIKE\nFor string comparison using wildcards or regular expressions, use `LIKE` or `RLIKE`:\n\nUse `LIKE` to match strings using wildcards. The following wildcard characters are supported:\n\n* `*` matches zero or more characters.\n* `?` matches one character.\n\n```\nFROM employees\n| WHERE first_name LIKE "?b*"\n| KEEP first_name, last_name\n```\n\nUse `RLIKE` to match strings using regular expressions:\n\n```\nFROM employees\n| WHERE first_name RLIKE ".leja.*"\n| KEEP first_name, last_name\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.predicates",{defaultMessage:"NULL values"}),description:Object(i.jsx)(s.Markdown,{markdown:a.i18n.translate("textBasedEditor.query.textBasedLanguagesEditor.documentationESQL.predicates.markdown",{defaultMessage:"### NULL values\nFor NULL comparison use the `IS NULL` and `IS NOT NULL` predicates:\n\n```\nFROM employees\n| WHERE birth_date IS NULL\n| KEEP first_name, last_name\n| SORT first_name\n| LIMIT 3\n```\n\n```\nFROM employees\n| WHERE is_rehired IS NOT NULL\n| STATS count(emp_no)\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})}]}}}]);