"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceLocationsRoute = void 0;
var _helpers = require("../settings/private_locations/helpers");
var _get_private_locations = require("../settings/private_locations/get_private_locations");
var _get_all_locations = require("../../synthetics_service/get_all_locations");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getServiceLocationsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.SERVICE_LOCATIONS,
  validate: {},
  handler: async ({
    request,
    server,
    savedObjectsClient,
    syntheticsMonitorClient
  }) => {
    var _Boolean, _server$coreStart;
    const elasticManagedLocationsEnabled = (_Boolean = Boolean((await ((_server$coreStart = server.coreStart) === null || _server$coreStart === void 0 ? void 0 : _server$coreStart.capabilities.resolveCapabilities(request, {
      capabilityPath: 'uptime.*'
    }))).uptime.elasticManagedLocationsEnabled)) !== null && _Boolean !== void 0 ? _Boolean : true;
    if (elasticManagedLocationsEnabled) {
      const {
        throttling,
        allLocations
      } = await (0, _get_all_locations.getAllLocations)({
        server,
        syntheticsMonitorClient,
        savedObjectsClient
      });
      return {
        locations: allLocations,
        throttling
      };
    } else {
      const {
        locations: privateLocations,
        agentPolicies
      } = await (0, _get_private_locations.getPrivateLocationsAndAgentPolicies)(savedObjectsClient, syntheticsMonitorClient);
      const result = (0, _helpers.toClientContract)({
        locations: privateLocations
      }, agentPolicies);
      return {
        locations: result
      };
    }
  }
});
exports.getServiceLocationsRoute = getServiceLocationsRoute;