"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.journeyScreenshotBlocksHandler = exports.createJourneyScreenshotBlocksRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _Either = require("fp-ts/Either");
var t = _interopRequireWildcard(require("io-ts"));
var _get_journey_screenshot_blocks = require("../../legacy_uptime/lib/requests/get_journey_screenshot_blocks");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createJourneyScreenshotBlocksRoute = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.JOURNEY_SCREENSHOT_BLOCKS,
  validate: {
    body: _configSchema.schema.object({
      hashes: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })
  },
  writeAccessOverride: true,
  handler: async routeProps => {
    return await journeyScreenshotBlocksHandler(routeProps);
  }
});
exports.createJourneyScreenshotBlocksRoute = createJourneyScreenshotBlocksRoute;
const journeyScreenshotBlocksHandler = async ({
  response,
  request,
  uptimeEsClient
}) => {
  const {
    hashes: blockIds
  } = request.body;
  if (!isStringArray(blockIds)) return response.badRequest();
  const result = await (0, _get_journey_screenshot_blocks.getJourneyScreenshotBlocks)({
    blockIds,
    uptimeEsClient
  });
  if (result.length === 0) {
    return response.notFound();
  }
  return response.ok({
    body: result
  });
};
exports.journeyScreenshotBlocksHandler = journeyScreenshotBlocksHandler;
function isStringArray(data) {
  return (0, _Either.isRight)(t.array(t.string).decode(data));
}