"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapSavedObjectToMonitor = mapSavedObjectToMonitor;
exports.mergeSourceMonitor = mergeSourceMonitor;
var _lodash = require("lodash");
var _runtime_types = require("../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapSavedObjectToMonitor(so) {
  return Object.assign(so.attributes, {
    created_at: so.created_at,
    updated_at: so.updated_at
  });
}
function mergeSourceMonitor(normalizedPreviousMonitor, monitor) {
  return (0, _lodash.mergeWith)(normalizedPreviousMonitor, monitor, customizer);
}

// Ensure that METADATA is merged deeply, to protect AAD and prevent decryption errors
const customizer = (destVal, srcValue, key) => {
  if (key === _runtime_types.ConfigKey.ALERT_CONFIG) {
    return {
      ...destVal,
      ...srcValue
    };
  }
  if (key !== _runtime_types.ConfigKey.METADATA) {
    return srcValue;
  }
};