"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsFilters = void 0;
var _saved_objects = require("../../../common/types/saved_objects");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsFilters = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.FILTERS,
  validate: {},
  handler: async ({
    savedObjectsClient
  }) => {
    var _ref, _monitorTypes$buckets, _monitorTypes$buckets2, _tags$buckets$map, _tags$buckets, _locations$buckets$ma, _locations$buckets, _projects$buckets$fil, _projects$buckets, _schedules$buckets$ma, _schedules$buckets;
    const data = await savedObjectsClient.find({
      type: _saved_objects.syntheticsMonitorType,
      perPage: 0,
      aggs
    });
    const {
      monitorTypes,
      tags,
      locations,
      projects,
      schedules
    } = (_ref = data === null || data === void 0 ? void 0 : data.aggregations) !== null && _ref !== void 0 ? _ref : {};
    return {
      monitorTypes: (_monitorTypes$buckets = monitorTypes === null || monitorTypes === void 0 ? void 0 : (_monitorTypes$buckets2 = monitorTypes.buckets) === null || _monitorTypes$buckets2 === void 0 ? void 0 : _monitorTypes$buckets2.map(({
        key,
        doc_count: count
      }) => ({
        label: key,
        count
      }))) !== null && _monitorTypes$buckets !== void 0 ? _monitorTypes$buckets : [],
      tags: (_tags$buckets$map = tags === null || tags === void 0 ? void 0 : (_tags$buckets = tags.buckets) === null || _tags$buckets === void 0 ? void 0 : _tags$buckets.map(({
        key,
        doc_count: count
      }) => ({
        label: key,
        count
      }))) !== null && _tags$buckets$map !== void 0 ? _tags$buckets$map : [],
      locations: (_locations$buckets$ma = locations === null || locations === void 0 ? void 0 : (_locations$buckets = locations.buckets) === null || _locations$buckets === void 0 ? void 0 : _locations$buckets.map(({
        key,
        doc_count: count
      }) => ({
        label: key,
        count
      }))) !== null && _locations$buckets$ma !== void 0 ? _locations$buckets$ma : [],
      projects: (_projects$buckets$fil = projects === null || projects === void 0 ? void 0 : (_projects$buckets = projects.buckets) === null || _projects$buckets === void 0 ? void 0 : _projects$buckets.filter(({
        key
      }) => key).map(({
        key,
        doc_count: count
      }) => ({
        label: key,
        count
      }))) !== null && _projects$buckets$fil !== void 0 ? _projects$buckets$fil : [],
      schedules: (_schedules$buckets$ma = schedules === null || schedules === void 0 ? void 0 : (_schedules$buckets = schedules.buckets) === null || _schedules$buckets === void 0 ? void 0 : _schedules$buckets.map(({
        key,
        doc_count: count
      }) => ({
        label: String(key),
        count
      }))) !== null && _schedules$buckets$ma !== void 0 ? _schedules$buckets$ma : []
    };
  }
});
exports.getSyntheticsFilters = getSyntheticsFilters;
const aggs = {
  monitorTypes: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.MONITOR_TYPE}.keyword`,
      size: 10000
    }
  },
  tags: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.TAGS}`,
      size: 10000
    }
  },
  locations: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.LOCATIONS}.id`,
      size: 10000
    }
  },
  projects: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.PROJECT_ID}`,
      size: 10000
    }
  },
  schedules: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.SCHEDULE}.number`,
      size: 10000
    }
  }
};