"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimeEsClient = void 0;
exports.createEsParams = createEsParams;
exports.debugESCall = debugESCall;
exports.isTestUser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _chalk = _interopRequireDefault(require("chalk"));
var _common = require("@kbn/inspector-plugin/common");
var _common2 = require("@kbn/observability-plugin/common");
var _common3 = require("@kbn/observability-shared-plugin/common");
var _constants = require("../common/constants");
var _saved_objects = require("./saved_objects/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UptimeEsClient {
  constructor(savedObjectsClient, esClient, options) {
    (0, _defineProperty2.default)(this, "isDev", void 0);
    (0, _defineProperty2.default)(this, "request", void 0);
    (0, _defineProperty2.default)(this, "baseESClient", void 0);
    (0, _defineProperty2.default)(this, "heartbeatIndices", void 0);
    (0, _defineProperty2.default)(this, "isInspectorEnabled", void 0);
    (0, _defineProperty2.default)(this, "inspectableEsQueries", []);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsClient", void 0);
    const {
      isDev = false,
      uiSettings,
      request,
      heartbeatIndices = ''
    } = options !== null && options !== void 0 ? options : {};
    this.uiSettings = uiSettings;
    this.baseESClient = esClient;
    this.savedObjectsClient = savedObjectsClient;
    this.request = request;
    this.heartbeatIndices = heartbeatIndices;
    this.isDev = isDev;
    this.inspectableEsQueries = [];
    this.getInspectEnabled();
  }
  async initSettings() {
    const self = this;
    const heartbeatIndices = await this.getIndices();
    self.heartbeatIndices = heartbeatIndices || '';
  }
  async search(params, operationName, index) {
    let res;
    let esError;
    await this.initSettings();
    const esParams = {
      index: index !== null && index !== void 0 ? index : this.heartbeatIndices,
      ...params
    };
    const startTime = process.hrtime();
    const startTimeNow = Date.now();
    let esRequestStatus = _common.RequestStatus.PENDING;
    try {
      res = await this.baseESClient.search(esParams, {
        meta: true
      });
      esRequestStatus = _common.RequestStatus.OK;
    } catch (e) {
      esError = e;
      esRequestStatus = _common.RequestStatus.ERROR;
    }
    if (this.request) {
      var _res;
      this.inspectableEsQueries.push((0, _common3.getInspectResponse)({
        esError,
        esRequestParams: esParams,
        esRequestStatus,
        esResponse: (_res = res) === null || _res === void 0 ? void 0 : _res.body,
        kibanaRequest: this.request,
        operationName: operationName !== null && operationName !== void 0 ? operationName : '',
        startTime: startTimeNow
      }));
    }
    const isInspectorEnabled = await this.getInspectEnabled();
    if (isInspectorEnabled && this.request) {
      debugESCall({
        startTime,
        request: this.request,
        esError,
        operationName: 'search',
        params: esParams
      });
    }
    if (esError) {
      throw esError;
    }
    return res;
  }
  async count(params) {
    let res;
    let esError;
    await this.initSettings();
    const esParams = {
      index: this.heartbeatIndices,
      ...params
    };
    const startTime = process.hrtime();
    try {
      res = await this.baseESClient.count(esParams, {
        meta: true
      });
    } catch (e) {
      esError = e;
    }
    const isInspectorEnabled = await this.getInspectEnabled();
    if (isInspectorEnabled && this.request) {
      debugESCall({
        startTime,
        request: this.request,
        esError,
        operationName: 'count',
        params: esParams
      });
    }
    if (esError) {
      throw esError;
    }
    return {
      result: res,
      indices: this.heartbeatIndices
    };
  }
  getSavedObjectsClient() {
    return this.savedObjectsClient;
  }
  async getInspectData(path) {
    const isInspectorEnabled = await this.getInspectEnabled();
    const showInspectData = (isInspectorEnabled || this.isDev) && path !== _constants.SYNTHETICS_API_URLS.DYNAMIC_SETTINGS;
    if (showInspectData && this.inspectableEsQueries.length > 0) {
      return {
        _inspect: this.inspectableEsQueries
      };
    }
    return {};
  }
  async getInspectEnabled() {
    if (this.isInspectorEnabled !== undefined) {
      return this.isInspectorEnabled;
    }
    if (!this.uiSettings) {
      return false;
    }
    this.isInspectorEnabled = this.uiSettings.client.get(_common2.enableInspectEsQueries);
  }
  async getIndices() {
    if (this.heartbeatIndices) {
      return this.heartbeatIndices;
    }
    const settings = await _saved_objects.savedObjectsAdapter.getUptimeDynamicSettings(this.savedObjectsClient);
    return (settings === null || settings === void 0 ? void 0 : settings.heartbeatIndices) || '';
  }
}
exports.UptimeEsClient = UptimeEsClient;
function createEsParams(params) {
  return params;
}

/* eslint-disable no-console */

function formatObj(obj) {
  return JSON.stringify(obj);
}
function debugESCall({
  operationName,
  params,
  request,
  esError,
  startTime
}) {
  const highlightColor = esError ? 'bgRed' : 'inverse';
  const diff = process.hrtime(startTime);
  const duration = `${Math.round(diff[0] * 1000 + diff[1] / 1e6)}ms`;
  const routeInfo = `${request.route.method.toUpperCase()} ${request.route.path}`;
  console.log(_chalk.default.bold[highlightColor](`=== Debug: ${routeInfo} (${duration}) ===`));
  if (operationName === 'search') {
    console.log(`GET ${params.index}/_${operationName}`);
    console.log(formatObj(params.body));
  } else {
    console.log(_chalk.default.bold('ES operation:'), operationName);
    console.log(_chalk.default.bold('ES query:'));
    console.log(formatObj(params));
  }
  console.log(`\n`);
}
const isTestUser = server => {
  var _server$config$servic;
  return ((_server$config$servic = server.config.service) === null || _server$config$servic === void 0 ? void 0 : _server$config$servic.username) === 'localKibanaIntegrationTestsUser';
};
exports.isTestUser = isTestUser;