"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TLSRuleExecutor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _moment = _interopRequireDefault(require("moment"));
var _client_defaults = require("../../../common/constants/client_defaults");
var _common = require("../common");
var _get_certs = require("../../queries/get_certs");
var _saved_objects = require("../../saved_objects");
var _constants = require("../../../common/constants");
var _get_all_monitors = require("../../saved_objects/synthetics_monitor/get_all_monitors");
var _runtime_types = require("../../../common/runtime_types");
var _saved_objects2 = require("../../../common/types/saved_objects");
var _monitor_management = require("../../../common/constants/monitor_management");
var _lib = require("../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TLSRuleExecutor {
  constructor(previousStartedAt, p, soClient, scopedClient, server, syntheticsMonitorClient) {
    (0, _defineProperty2.default)(this, "previousStartedAt", void 0);
    (0, _defineProperty2.default)(this, "params", void 0);
    (0, _defineProperty2.default)(this, "esClient", void 0);
    (0, _defineProperty2.default)(this, "soClient", void 0);
    (0, _defineProperty2.default)(this, "server", void 0);
    (0, _defineProperty2.default)(this, "syntheticsMonitorClient", void 0);
    (0, _defineProperty2.default)(this, "monitors", []);
    this.previousStartedAt = previousStartedAt;
    this.params = p;
    this.soClient = soClient;
    this.esClient = new _lib.UptimeEsClient(this.soClient, scopedClient, {
      heartbeatIndices: _constants.SYNTHETICS_INDEX_PATTERN
    });
    this.server = server;
    this.syntheticsMonitorClient = syntheticsMonitorClient;
  }
  async getMonitors() {
    const HTTP_OR_TCP = `${_saved_objects2.monitorAttributes}.${_runtime_types.ConfigKey.MONITOR_TYPE}: http or ${_saved_objects2.monitorAttributes}.${_runtime_types.ConfigKey.MONITOR_TYPE}: tcp`;
    this.monitors = await (0, _get_all_monitors.getAllMonitors)({
      soClient: this.soClient,
      filter: `${_saved_objects2.monitorAttributes}.${_monitor_management.AlertConfigKey.TLS_ENABLED}: true and (${HTTP_OR_TCP})`
    });
    const {
      allIds,
      enabledMonitorQueryIds,
      monitorLocationIds,
      monitorLocationMap,
      projectMonitorsCount,
      monitorQueryIdToConfigIdMap
    } = (0, _get_all_monitors.processMonitors)(this.monitors, this.server, this.soClient, this.syntheticsMonitorClient);
    return {
      enabledMonitorQueryIds,
      monitorLocationIds,
      allIds,
      monitorLocationMap,
      projectMonitorsCount,
      monitorQueryIdToConfigIdMap
    };
  }
  async getExpiredCertificates() {
    var _ref, _this$params$certExpi, _ref2, _this$params$certAgeT;
    const {
      enabledMonitorQueryIds
    } = await this.getMonitors();
    const dynamicSettings = await _saved_objects.savedObjectsAdapter.getUptimeDynamicSettings(this.soClient);
    const expiryThreshold = (_ref = (_this$params$certExpi = this.params.certExpirationThreshold) !== null && _this$params$certExpi !== void 0 ? _this$params$certExpi : dynamicSettings === null || dynamicSettings === void 0 ? void 0 : dynamicSettings.certExpirationThreshold) !== null && _ref !== void 0 ? _ref : _constants.DYNAMIC_SETTINGS_DEFAULTS.certExpirationThreshold;
    const ageThreshold = (_ref2 = (_this$params$certAgeT = this.params.certAgeThreshold) !== null && _this$params$certAgeT !== void 0 ? _this$params$certAgeT : dynamicSettings === null || dynamicSettings === void 0 ? void 0 : dynamicSettings.certAgeThreshold) !== null && _ref2 !== void 0 ? _ref2 : _constants.DYNAMIC_SETTINGS_DEFAULTS.certAgeThreshold;
    const absoluteExpirationThreshold = (0, _moment.default)().add(expiryThreshold, 'd').valueOf();
    const absoluteAgeThreshold = (0, _moment.default)().subtract(ageThreshold, 'd').valueOf();
    if (enabledMonitorQueryIds.length === 0) {
      return {
        latestPings: [],
        certs: [],
        total: 0,
        foundCerts: false,
        expiryThreshold,
        ageThreshold,
        absoluteExpirationThreshold,
        absoluteAgeThreshold
      };
    }
    let filters;
    if (this.params.search) {
      filters = await (0, _common.formatFilterString)(this.esClient, undefined, this.params.search);
    }
    const {
      certs,
      total
    } = await (0, _get_certs.getSyntheticsCerts)({
      uptimeEsClient: this.esClient,
      pageIndex: 0,
      size: 1000,
      notValidAfter: `now+${expiryThreshold}d`,
      notValidBefore: `now-${ageThreshold}d`,
      sortBy: 'common_name',
      direction: 'desc',
      filters,
      monitorIds: enabledMonitorQueryIds
    });
    const latestPings = await this.getLatestPingsForMonitors(certs);
    const foundCerts = total > 0;
    return {
      latestPings,
      foundCerts,
      total,
      expiryThreshold,
      ageThreshold,
      absoluteExpirationThreshold,
      absoluteAgeThreshold,
      certs: this.filterOutResolvedCerts(certs, latestPings)
    };
  }
  filterOutResolvedCerts(certs, latestPings) {
    const latestPingsMap = new Map();
    latestPings.forEach(ping => {
      latestPingsMap.set(ping.config_id, ping);
    });
    return certs.filter(cert => {
      const lPing = latestPingsMap.get(cert.configId);
      if (!lPing) {
        return true;
      }
      return (0, _moment.default)(lPing['@timestamp']).isBefore(cert['@timestamp']);
    });
  }
  async getLatestPingsForMonitors(certs) {
    if (certs.length === 0) {
      return [];
    }
    const configIds = certs.map(cert => cert.configId);
    const certIds = certs.map(cert => cert.sha256);
    const {
      body
    } = await this.esClient.search({
      body: {
        query: {
          bool: {
            filter: [{
              range: {
                '@timestamp': {
                  gte: 'now-1d',
                  lt: 'now'
                }
              }
            }, {
              terms: {
                config_id: configIds
              }
            }, _client_defaults.FINAL_SUMMARY_FILTER],
            must_not: {
              bool: {
                filter: [{
                  terms: {
                    'tls.server.hash.sha256': certIds
                  }
                }]
              }
            }
          }
        },
        collapse: {
          field: 'config_id'
        },
        _source: ['@timestamp', 'monitor', 'url', 'config_id', 'tls'],
        sort: [{
          '@timestamp': {
            order: 'desc'
          }
        }]
      }
    });
    return body.hits.hits.map(hit => hit._source);
  }
}
exports.TLSRuleExecutor = TLSRuleExecutor;