"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallTimingLegend = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../../common/network_data/types");
var _data_formatting = require("../../../common/network_data/data_formatting");
var _waterfall_legend_item = require("./waterfall_legend_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WaterfallTimingLegend = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    css: {
      gap: `min(3%, ${euiTheme.size.l})`
    }
  }, Object.values(_types.Timings).filter(t => t !== _types.Timings.Receive).map(t => /*#__PURE__*/_react.default.createElement(_waterfall_legend_item.WaterfallLegendItem, {
    key: t,
    id: t,
    color: _data_formatting.colourPalette[t],
    label: _types.FriendlyTimingLabels[t]
  })));
};
exports.WaterfallTimingLegend = WaterfallTimingLegend;