"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewErrors = OverviewErrors;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _overview_alerts = require("../overview_alerts");
var _overview_status = require("../../../../../state/overview_status");
var _overview_errors_sparklines = require("./overview_errors_sparklines");
var _hooks = require("../../../../../hooks");
var _overview_errors_count = require("./overview_errors_count");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function OverviewErrors() {
  const {
    status
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const loading = !(status !== null && status !== void 0 && status.allIds) || (status === null || status === void 0 ? void 0 : status.allIds.length) === 0;
  const {
    from,
    to
  } = (0, _hooks.useRefreshedRange)(6, 'hours');
  const {
    locations
  } = (0, _hooks.useGetUrlParams)();
  const monitorIds = (0, _overview_alerts.useMonitorQueryIds)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, headingText)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_overview_errors_count.OverviewErrorsCount, {
    from: from,
    to: to,
    monitorIds: monitorIds,
    locations: locations
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_overview_errors_sparklines.OverviewErrorsSparklines, {
    from: from,
    to: to,
    monitorIds: monitorIds,
    locations: locations
  }))));
}
const headingText = _i18n.i18n.translate('xpack.synthetics.overview.errors.headingText', {
  defaultMessage: 'Last 6 hours'
});