"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MEDIAN_DURATION_LABEL = exports.DurationPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DurationPanel = props => {
  const {
    services: {
      exploratoryView: {
        ExploratoryViewEmbeddable
      }
    }
  } = (0, _public.useKibana)();
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  if (!queryIdFilter) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: props.id,
    align: "left",
    customHeight: "70px",
    reportType: _public2.ReportTypes.SINGLE_METRIC,
    attributes: [{
      time: props,
      name: MEDIAN_DURATION_LABEL,
      dataType: 'synthetics',
      selectedMetricField: 'monitor_duration',
      reportDefinitions: queryIdFilter,
      filters: locationFilter
    }]
  });
};
exports.DurationPanel = DurationPanel;
const MEDIAN_DURATION_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.medianDuration', {
  defaultMessage: 'Median duration'
});
exports.MEDIAN_DURATION_LABEL = MEDIAN_DURATION_LABEL;