"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusCellTooltip = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _monitor_status_data = require("./monitor_status_data");
var labels = _interopRequireWildcard(require("./labels"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorStatusCellTooltip = ({
  timeBin,
  isLoading
}) => {
  if (!timeBin) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '');
  }
  const startM = (0, _moment.default)(timeBin.start);
  const endM = (0, _moment.default)(timeBin.end);
  const startDateStr = startM.format('LL');
  const timeStartStr = startM.format('HH:mm');
  const timeEndStr = endM.format('HH:mm');
  const isDifferentDays = startM.dayOfYear() !== endM.dayOfYear();

  // If start and end days are different, show date for both of the days
  const endDateSegment = isDifferentDays ? `${endM.format('LL')} @ ` : '';
  const tooltipTitle = `${startDateStr} @ ${timeStartStr} - ${endDateSegment}${timeEndStr}`;
  const availabilityStr = timeBin.ups + timeBin.downs > 0 ? `${Math.round(timeBin.ups / (timeBin.ups + timeBin.downs) * 100)}%` : '-';

  // not currently used but required by current types
  const commonTooltipValuesProps = {
    isVisible: true,
    isHighlighted: false,
    seriesIdentifier: {
      specId: '',
      key: ''
    }
  };
  const tooltipValues = isLoading ? [] : [{
    color: 'transparent',
    label: labels.AVAILABILITY_LABEL,
    value: availabilityStr,
    formattedValue: availabilityStr,
    ...commonTooltipValuesProps
  }, {
    color: _monitor_status_data.SUCCESS_VIZ_COLOR,
    label: labels.COMPLETE_LABEL,
    value: timeBin.ups,
    formattedValue: `${timeBin.ups}`,
    ...commonTooltipValuesProps
  }, {
    color: _monitor_status_data.DANGER_VIZ_COLOR,
    label: labels.FAILED_LABEL,
    value: timeBin.downs,
    formattedValue: `${timeBin.downs}`,
    ...commonTooltipValuesProps
  }];
  return /*#__PURE__*/_react.default.createElement(_charts.TooltipContainer, null, /*#__PURE__*/_react.default.createElement(_charts.TooltipHeader, null, tooltipTitle), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_charts.TooltipTable, {
    columns: [{
      type: 'color'
    }, {
      type: 'text',
      cell: t => t.label,
      style: {
        textAlign: 'left'
      }
    }, {
      type: 'number',
      cell: t => t.value,
      style: {
        textAlign: 'right'
      }
    }],
    items: tooltipValues
  }));
};
exports.MonitorStatusCellTooltip = MonitorStatusCellTooltip;