"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorFailedTests = exports.FAILED_TESTS_LABEL = exports.BRUSH_LABEL = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorFailedTests = ({
  time,
  allowBrushing = true
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  const {
    errorStateId
  } = (0, _reactRouterDom.useParams)();
  const [, updateUrl] = (0, _hooks.useUrlParams)();
  if (!queryIdFilter && !errorStateId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: 'failedTestsLineSeries',
    customHeight: '120px',
    reportType: "heatmap",
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: false,
    attributes: [{
      time,
      reportDefinitions: {
        ...queryIdFilter,
        ...(errorStateId ? {
          'state.id': [errorStateId]
        } : {})
      },
      filters: locationFilter,
      dataType: 'synthetics',
      selectedMetricField: 'failed_tests',
      name: FAILED_TESTS_LABEL
    }],
    onBrushEnd: ({
      range
    }) => {
      if (allowBrushing) {
        updateUrl({
          dateRangeStart: (0, _moment.default)(range[0]).toISOString(),
          dateRangeEnd: (0, _moment.default)(range[1]).toISOString()
        });
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      marginLeft: 10
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger"
  }, FAILED_TESTS_LABEL)), allowBrushing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, BRUSH_LABEL))));
};
exports.MonitorFailedTests = MonitorFailedTests;
const FAILED_TESTS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.failedTests', {
  defaultMessage: 'Failed tests'
});
exports.FAILED_TESTS_LABEL = FAILED_TESTS_LABEL;
const BRUSH_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.brushArea', {
  defaultMessage: 'Brush an area for higher fidelity'
});
exports.BRUSH_LABEL = BRUSH_LABEL;