"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _use_form_wrapped = require("../../../../../hooks/use_form_wrapped");
var _types = require("../types");
var _defaults = require("./defaults");
var _submit = require("./submit");
var _disclaimer = require("./disclaimer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorForm = ({
  children,
  defaultValues,
  space,
  readOnly = false,
  canUsePublicLocations
}) => {
  const methods = (0, _use_form_wrapped.useFormWrapped)({
    mode: 'onSubmit',
    reValidateMode: 'onSubmit',
    defaultValues: (0, _defaults.formatDefaultFormValues)(defaultValues) || (0, _defaults.getDefaultFormFields)(space)[_types.FormMonitorType.MULTISTEP],
    shouldFocusError: false
  });

  /* React hook form doesn't seem to register a field
   * as dirty until validation unless dirtyFields is subscribed to */
  const {
    formState: {
      isSubmitted,
      errors,
      dirtyFields: _
    }
  } = methods;
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, methods, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: Boolean(isSubmitted && Object.keys(errors).length),
    component: "form",
    noValidate: true
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_submit.ActionBar, {
    readOnly: readOnly,
    canUsePublicLocations: canUsePublicLocations
  })), /*#__PURE__*/_react.default.createElement(_disclaimer.Disclaimer, null));
};
exports.MonitorForm = MonitorForm;